/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.gestures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphNode;

public class RotateGestureListener
implements GestureListener {
    Graph graph;
    double rotate;
    List nodes;
    List originalLocations;
    double xCenter;
    double yCenter;

    void storePosition(List nodes) {
        this.originalLocations = new ArrayList();
        Iterator it = nodes.iterator();
        Transform t = new Transform();
        t.setTranslation(-this.xCenter, -this.yCenter);
        while (it.hasNext()) {
            GraphNode node = (GraphNode)((Object)it.next());
            this.originalLocations.add(t.getTransformed(node.getLocation()));
        }
    }

    void updatePositions(double rotation) {
        Transform t = new Transform();
        t.setRotation(rotation);
        t.setTranslation(this.xCenter, this.yCenter);
        int i = 0;
        while (i < this.nodes.size()) {
            GraphNode node = (GraphNode)((Object)this.nodes.get(i));
            Point p = (Point)this.originalLocations.get(i);
            Point rot = t.getTransformed(p);
            node.setLocation(rot.preciseX(), rot.preciseY());
            ++i;
        }
    }

    public void gesture(GestureEvent e) {
        if (!(e.widget instanceof Graph)) {
            return;
        }
        switch (e.detail) {
            case 2: {
                this.graph = (Graph)e.widget;
                this.rotate = 0.0;
                this.nodes = this.graph.getSelection();
                if (this.nodes.isEmpty()) {
                    this.nodes = this.graph.getNodes();
                }
                this.xCenter = 0.0;
                this.yCenter = 0.0;
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    GraphNode node = (GraphNode)((Object)it.next());
                    Point location = node.getLocation();
                    this.xCenter += location.preciseX();
                    this.yCenter += location.preciseY();
                }
                this.xCenter /= (double)this.nodes.size();
                this.yCenter /= (double)this.nodes.size();
                this.storePosition(this.nodes);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.updatePositions(e.rotation / 2.0 / Math.PI);
            }
        }
    }
}

