/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableBarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableComparisonChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableTubeChartConfig;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class TableComparisonChart
extends PropertyPage {
    private TableComparisonChartConfig config;
    private LabeledText title;
    private Spinner refreshRate;
    private Combo legendPosition;
    private Button checkShowTitle;
    private Button checkShowLegend;
    private Button checkShowIn3D;
    private Button checkTranslucent;
    private Button checkTransposed;

    protected Control createContents(Composite parent) {
        this.config = (TableComparisonChartConfig)this.getElement().getAdapter(TableComparisonChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel(Messages.TableComparisonChart_Title);
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.TableComparisonChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        this.legendPosition.add(Messages.TableComparisonChart_Left);
        this.legendPosition.add(Messages.TableComparisonChart_Right);
        this.legendPosition.add(Messages.TableComparisonChart_Top);
        this.legendPosition.add(Messages.TableComparisonChart_Bottom);
        this.legendPosition.select(this.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(Messages.TableComparisonChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowTitle = new Button((Composite)optionsGroup, 32);
        this.checkShowTitle.setText(Messages.TableComparisonChart_ShowTitle);
        this.checkShowTitle.setSelection(this.config.isShowTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowTitle.setLayoutData((Object)gd);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(Messages.TableComparisonChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkShowIn3D = new Button((Composite)optionsGroup, 32);
        this.checkShowIn3D.setText(Messages.TableComparisonChart_3DView);
        this.checkShowIn3D.setSelection(this.config.isShowIn3D());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowIn3D.setLayoutData((Object)gd);
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(Messages.TableComparisonChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        if (this.config instanceof TableBarChartConfig || this.config instanceof TableTubeChartConfig) {
            this.checkTransposed = new Button((Composite)optionsGroup, 32);
            this.checkTransposed.setText(Messages.TableComparisonChart_Transposed);
            this.checkTransposed.setSelection(this.config instanceof TableBarChartConfig ? ((TableBarChartConfig)this.config).isTransposed() : ((TableTubeChartConfig)this.config).isTransposed());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkTransposed.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.TableComparisonChart_RefreshInterval, (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    private int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public boolean performOk() {
        this.config.setTitle(this.title.getText());
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setShowTitle(this.checkShowTitle.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setShowIn3D(this.checkShowIn3D.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        if (this.config instanceof TableBarChartConfig) {
            ((TableBarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        } else if (this.config instanceof TableTubeChartConfig) {
            ((TableTubeChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        }
        return true;
    }
}

