/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DataCollectionEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.view.data_collection_editor";
    public static final String JOB_FAMILY = "DataCollectionEditorJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_ORIGIN = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_PARAMETER = 3;
    public static final int COLUMN_DATATYPE = 4;
    public static final int COLUMN_INTERVAL = 5;
    public static final int COLUMN_RETENTION = 6;
    public static final int COLUMN_STATUS = 7;
    public static final int COLUMN_TEMPLATE = 8;
    private boolean filterEnabled = false;
    private Composite content;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private NXCSession session;
    private GenericObject object;
    private DataCollectionConfiguration dciConfig = null;
    private DciFilter filter;
    private Action actionCreateItem;
    private Action actionCreateTable;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionCopy;
    private Action actionMove;
    private Action actionConvert;
    private Action actionDuplicate;
    private Action actionActivate;
    private Action actionDisable;
    private Action actionShowFilter;
    private RefreshAction actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        this.object = obj != null && (obj instanceof Node || obj instanceof Template || obj instanceof Cluster) ? obj : null;
        this.setPartName(String.valueOf(Messages.DataCollectionEditor_PartNamePrefix) + (this.object != null ? this.object.getObjectName() : Messages.DataCollectionEditor_Error));
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataCollectionEditor.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                DataCollectionEditor.this.enableFilter(false);
            }
        });
        String[] names = new String[]{Messages.DataCollectionEditor_ColID, Messages.DataCollectionEditor_ColOrigin, Messages.DataCollectionEditor_ColDescription, Messages.DataCollectionEditor_ColParameter, Messages.DataCollectionEditor_ColDataType, Messages.DataCollectionEditor_ColPollingInterval, Messages.DataCollectionEditor_ColRetentionTime, Messages.DataCollectionEditor_ColStatus, Messages.DataCollectionEditor_ColTemplate};
        int[] widths = new int[]{60, 100, 250, 200, 90, 90, 90, 100, 150};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DciComparator((DciLabelProvider)this.viewer.getLabelProvider()));
        this.filter = new DciFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"DataCollectionEditor");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    DataCollectionEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    DataCollectionEditor.this.actionDelete.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionCopy.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionMove.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionConvert.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionDuplicate.setEnabled(selection.size() > 0);
                    Iterator it = selection.iterator();
                    boolean canActivate = false;
                    boolean canDisable = false;
                    while (!(!it.hasNext() || canActivate && canDisable)) {
                        DataCollectionObject dci = (DataCollectionObject)it.next();
                        if (dci.getStatus() != 0) {
                            canActivate = true;
                        }
                        if (dci.getStatus() == 1) continue;
                        canDisable = true;
                    }
                    DataCollectionEditor.this.actionActivate.setEnabled(canActivate);
                    DataCollectionEditor.this.actionDisable.setEnabled(canDisable);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataCollectionEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)DataCollectionEditor.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"DataCollectionEditor");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_OpenJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig = DataCollectionEditor.this.session.openDataCollectionConfiguration(DataCollectionEditor.this.object.getObjectId());
                DataCollectionEditor.this.dciConfig.setUserData((Object)DataCollectionEditor.this.viewer);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.getViewSite().getPage().hideView((IViewPart)DataCollectionEditor.this);
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_OpenJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionCreateTable);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        manager.add((IAction)this.actionConvert);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionCreateTable);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        manager.add((IAction)this.actionConvert);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
            }
        };
        this.actionCreateItem = new Action(Messages.DataCollectionEditor_NewParam, Activator.getImageDescriptor("icons/new.png")){

            public void run() {
                DataCollectionEditor.this.createItem();
            }
        };
        this.actionCreateTable = new Action(Messages.DataCollectionEditor_NewTable){

            public void run() {
                DataCollectionEditor.this.createTable();
            }
        };
        this.actionEdit = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer){

            public void run() {
                super.run();
                DataCollectionEditor.this.viewer.refresh();
            }
        };
        this.actionEdit.setText(Messages.DataCollectionEditor_Edit);
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionDelete = new Action(Messages.DataCollectionEditor_Delete, Activator.getImageDescriptor("icons/delete.png")){

            public void run() {
                DataCollectionEditor.this.deleteItems();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionCopy = new Action(Messages.DataCollectionEditor_Copy){

            public void run() {
                DataCollectionEditor.this.copyItems(false);
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionMove = new Action(Messages.DataCollectionEditor_Move){

            public void run() {
                DataCollectionEditor.this.copyItems(true);
            }
        };
        this.actionMove.setEnabled(false);
        this.actionConvert = new Action(Messages.DataCollectionEditor_Convert){

            public void run() {
                DataCollectionEditor.this.convertToTemplate();
            }
        };
        this.actionConvert.setEnabled(false);
        this.actionDuplicate = new Action(Messages.DataCollectionEditor_Duplicate){

            public void run() {
                DataCollectionEditor.this.duplicateItems();
            }
        };
        this.actionDuplicate.setEnabled(false);
        this.actionActivate = new Action(Messages.DataCollectionEditor_Activate, Activator.getImageDescriptor("icons/active.gif")){

            public void run() {
                DataCollectionEditor.this.setItemStatus(0);
            }
        };
        this.actionActivate.setEnabled(false);
        this.actionDisable = new Action(Messages.DataCollectionEditor_Disable, Activator.getImageDescriptor("icons/disabled.gif")){

            public void run() {
                DataCollectionEditor.this.setItemStatus(1);
            }
        };
        this.actionDisable.setEnabled(false);
        this.actionShowFilter = new Action(Messages.DataCollectionEditor_ShowFilter, 2){

            public void run() {
                DataCollectionEditor.this.enableFilter(!DataCollectionEditor.this.filterEnabled);
                DataCollectionEditor.this.actionShowFilter.setChecked(DataCollectionEditor.this.filterEnabled);
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DataCollectionEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.dciConfig != null) {
            new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_UnlockJob_Title) + this.object.getObjectName(), null, "org.netxms.ui.eclipse.datacollection", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    DataCollectionEditor.this.dciConfig.close();
                    DataCollectionEditor.this.dciConfig = null;
                }

                protected String getErrorMessage() {
                    return String.valueOf(Messages.DataCollectionEditor_UnlockJob_Error) + DataCollectionEditor.this.object.getObjectName();
                }
            }.start();
        }
        super.dispose();
    }

    private void setItemStatus(final int newStatus) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_ChStatusJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long[] itemList = new long[selection.size()];
                int pos = 0;
                for (Object dci : selection.toList()) {
                    itemList[pos++] = ((DataCollectionObject)dci).getId();
                }
                DataCollectionEditor.this.dciConfig.setObjectStatus(itemList, newStatus);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (Object dci : selection.toList()) {
                            ((DataCollectionObject)dci).setStatus(newStatus);
                            DataCollectionEditor.this.viewer.update(dci, null);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_ChStatusJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void deleteItems() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.DataCollectionEditor_DeleteConfirmTitle, (String)Messages.DataCollectionEditor_DeleteConfirmText)) {
            return;
        }
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_DeleteJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object dci : selection.toList()) {
                    DataCollectionEditor.this.dciConfig.deleteObject(((DataCollectionObject)dci).getId());
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_DeleteJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void createItem() {
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_CreateJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final long id = DataCollectionEditor.this.dciConfig.createItem();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        DataCollectionItem dci = (DataCollectionItem)DataCollectionEditor.this.dciConfig.findItem(id, DataCollectionItem.class);
                        DataCollectionEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci), true);
                        DataCollectionEditor.this.actionEdit.run();
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_CreateJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void createTable() {
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_TableCreateJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final long id = DataCollectionEditor.this.dciConfig.createTable();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        DataCollectionTable dci = (DataCollectionTable)DataCollectionEditor.this.dciConfig.findItem(id, DataCollectionTable.class);
                        DataCollectionEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)dci), true);
                        DataCollectionEditor.this.actionEdit.run();
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_TableCreateJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void duplicateItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_DupJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig.copyObjects(DataCollectionEditor.this.dciConfig.getNodeId(), dciList);
                DataCollectionEditor.this.dciConfig.close();
                DataCollectionEditor.this.dciConfig.open();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_DupJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void copyItems(final boolean doMove) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeAndTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_CopyJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GenericObject o;
                GenericObject[] genericObjectArray = dlg.getSelectedObjects(Node.class);
                int n = genericObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    o = genericObjectArray[n2];
                    DataCollectionEditor.this.dciConfig.copyObjects(o.getObjectId(), dciList);
                    ++n2;
                }
                genericObjectArray = dlg.getSelectedObjects(Template.class);
                n = genericObjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    o = genericObjectArray[n2];
                    DataCollectionEditor.this.dciConfig.copyObjects(o.getObjectId(), dciList);
                    ++n2;
                }
                if (doMove) {
                    long[] lArray = dciList;
                    int n3 = dciList.length;
                    n = 0;
                    while (n < n3) {
                        long id = lArray[n];
                        DataCollectionEditor.this.dciConfig.deleteObject(id);
                        ++n;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_CopyJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void convertToTemplate() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        GenericObject[] objects = dlg.getSelectedObjects(Template.class);
        if (objects.length == 0) {
            return;
        }
        final Template template = (Template)objects[0];
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_ConvertJob_TitlePrefix) + this.object.getObjectName() + Messages.DataCollectionEditor_ConvertJob_TitleSuffix, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int retries;
                long id;
                monitor.beginTask(Messages.DataCollectionEditor_ConvertJob_TaskName, 4);
                boolean needApply = true;
                long[] lArray = template.getChildIdList();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    if (id == DataCollectionEditor.this.dciConfig.getNodeId()) {
                        needApply = false;
                        break;
                    }
                    ++n2;
                }
                monitor.worked(1);
                DataCollectionEditor.this.dciConfig.copyObjects(template.getObjectId(), dciList);
                lArray = dciList;
                n = dciList.length;
                n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    DataCollectionEditor.this.dciConfig.deleteObject(id);
                    ++n2;
                }
                DataCollectionEditor.this.dciConfig.close();
                monitor.worked(1);
                if (needApply) {
                    boolean success = false;
                    retries = 5;
                    do {
                        try {
                            DataCollectionEditor.this.session.applyTemplate(template.getObjectId(), DataCollectionEditor.this.dciConfig.getNodeId());
                            success = true;
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() != 1) {
                                throw e;
                            }
                            Thread.sleep(200L);
                        }
                    } while (!success && --retries > 0);
                }
                monitor.worked(1);
                boolean success = false;
                retries = 5;
                do {
                    try {
                        Thread.sleep(500L);
                        DataCollectionEditor.this.dciConfig.open();
                        success = true;
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 1) continue;
                        throw e;
                    }
                } while (!success && --retries > 0);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
                monitor.done();
            }

            protected String getErrorMessage() {
                return String.valueOf(Messages.DataCollectionEditor_ConvertJob_ErrorPrefix) + DataCollectionEditor.this.object.getObjectName() + Messages.DataCollectionEditor_ConvertJob_ErrorSuffix;
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

