/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciLabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<Integer, String> originTexts = new HashMap();
    private HashMap<Integer, String> dtTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.statusImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.statusImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        this.originTexts.put(1, Messages.DciLabelProvider_SourceAgent);
        this.originTexts.put(2, Messages.DciLabelProvider_SourceSNMP);
        this.originTexts.put(3, Messages.DciLabelProvider_SourceCPSNMP);
        this.originTexts.put(0, Messages.DciLabelProvider_SourceInternal);
        this.originTexts.put(4, Messages.DciLabelProvider_SourcePush);
        this.statusTexts.put(0, Messages.DciLabelProvider_Active);
        this.statusTexts.put(1, Messages.DciLabelProvider_Disabled);
        this.statusTexts.put(2, Messages.DciLabelProvider_NotSupported);
        this.dtTexts.put(0, Messages.DciLabelProvider_DT_int32);
        this.dtTexts.put(1, Messages.DciLabelProvider_DT_uint32);
        this.dtTexts.put(2, Messages.DciLabelProvider_DT_int64);
        this.dtTexts.put(3, Messages.DciLabelProvider_DT_uint64);
        this.dtTexts.put(5, Messages.DciLabelProvider_DT_float);
        this.dtTexts.put(4, Messages.DciLabelProvider_DT_string);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    return this.dtTexts.get(((DataCollectionItem)dci).getDataType());
                }
                return Messages.DciLabelProvider_Table;
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    return Messages.DciLabelProvider_CustomSchedule;
                }
                return Integer.toString(dci.getPollingInterval());
            }
            case 6: {
                int days = dci.getRetentionTime();
                return String.valueOf(Integer.toString(days)) + (days == 1 ? Messages.DciLabelProvider_Day : Messages.DciLabelProvider_Days);
            }
            case 7: {
                return this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                GenericObject object = this.session.findObjectById(dci.getTemplateId());
                return object != null ? object.getObjectName() : Messages.DciLabelProvider_Unknown;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

