/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverjobmanager.views.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.NXCServerJob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.serverjobmanager.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerJobLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Map<Integer, String> statusTexts = new HashMap<Integer, String>(5);
    private Map<Integer, Image> statusImages = new HashMap<Integer, Image>(5);

    public ServerJobLabelProvider() {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.statusTexts.put(1, "Active");
        this.statusTexts.put(6, "Cancel pending");
        this.statusTexts.put(5, "Cancelled");
        this.statusTexts.put(3, "Completed");
        this.statusTexts.put(4, "Failed");
        this.statusTexts.put(2, "On hold");
        this.statusTexts.put(0, "Pending");
        this.statusImages.put(1, Activator.getImageDescriptor("icons/active.gif").createImage());
        this.statusImages.put(6, Activator.getImageDescriptor("icons/cancel_pending.png").createImage());
        this.statusImages.put(5, Activator.getImageDescriptor("icons/cancel.png").createImage());
        this.statusImages.put(3, Activator.getImageDescriptor("icons/completed.gif").createImage());
        this.statusImages.put(4, Activator.getImageDescriptor("icons/failed.png").createImage());
        this.statusImages.put(2, Activator.getImageDescriptor("icons/hold.gif").createImage());
        this.statusImages.put(0, Activator.getImageDescriptor("icons/pending.gif").createImage());
    }

    public String getColumnText(Object obj, int index) {
        if (obj instanceof NXCServerJob) {
            switch (index) {
                case 0: {
                    return this.statusTexts.get(((NXCServerJob)obj).getStatus());
                }
                case 1: {
                    AbstractUserObject user = this.session.findUserDBObjectById(((NXCServerJob)obj).getUserId());
                    return user != null ? user.getName() : "<unknown>";
                }
                case 2: {
                    GenericObject object = this.session.findObjectById(((NXCServerJob)obj).getNodeId());
                    return object != null ? object.getObjectName() : "<unknown>";
                }
                case 3: {
                    return ((NXCServerJob)obj).getDescription();
                }
                case 4: {
                    return ((NXCServerJob)obj).getStatus() == 1 ? String.valueOf(Integer.toString(((NXCServerJob)obj).getProgress())) + "%" : "";
                }
                case 5: {
                    return ((NXCServerJob)obj).getFailureMessage();
                }
            }
        }
        return "";
    }

    public void dispose() {
        for (Image image : this.statusImages.values()) {
            image.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object obj) {
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof NXCServerJob) || columnIndex != 0) {
            return null;
        }
        return this.statusImages.get(((NXCServerJob)element).getStatus());
    }
}

