/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.HashMap;
import java.util.Map;
import org.netxms.api.client.NetXMSClientException;

public class NXCException
extends NetXMSClientException {
    private static final long serialVersionUID = -3247688667511123892L;
    private static final String[] errorTexts_en = new String[]{"Request completed successfully", "Component locked", "Access denied", "Invalid request", "Request timed out", "Request is out of state", "Database failure", "Invalid object ID", "Object already exist", "Communication failure", "System failure", "Invalid user ID", "Invalid argument", "Duplicate DCI", "Invalid DCI ID", "Out of memory", "Input/Output error", "Incompatible operation", "Object creation failed", "Loop in object relationship detected", "Invalid object name", "Invalid alarm ID", "Invalid action ID", "Operation in progress", "Copy operation failed for one or more DCI(s)", "Invalid or unknown event code", "No interfaces suitable for sending magic packet", "No MAC address on interface", "Command not implemented", "Invalid trap configuration record ID", "Requested data collection item is not supported by agent", "Client and server versions mismatch", "Error parsing package information file", "Package with specified properties already installed on server", "Package file already exist on server", "Server resource busy", "Invalid package ID", "Invalid IP address", "Action is used in event processing policy", "Variable not found", "Server uses incompatible version of communication protocol", "Address already in use", "Unable to select cipher", "Invalid public key", "Invalid session key", "Encryption is not supported by peer", "Server internal error", "Execution of external command failed", "Invalid object tool ID", "SNMP protocol error", "Incorrect regular expression", "Parameter is not supported by agent", "File I/O operation failed", "MIB file is corrupted", "File transfer operation already in progress", "Invalid job ID", "Invalid script ID", "Invalid script name", "Unknown map name", "Invalid map ID", "Account disabled", "No more grace logins", "Server connection broken", "Invalid agent configuration ID", "Server has lost connection with backend database", "Alarm is still open in helpdesk system", "Alarm is not in \"outstanding\" state", "DCI data source is not a push agent", "Error parsing configuration import file", "Configuration cannot be imported because of validation errors", "Invalid graph ID", "Local cryptographic provider failure", "Unsupported authentication type", "Bad certificate", "Invalid certificate ID", "SNMP failure", "Node has no support for layer 2 topology discovery", "Invalid situation ID", "Named instance not found", "Invalid event ID", "Operation cannot be completed due to agent error", "Unknown variable", "Requested resource not available", "Job cannot be cancelled", "Invalid policy ID", "Unknown log name", "Invalid log handle", "New password is too weak", "Password was used before", "Invalid session handle", "Node already is a member of a cluster", "Job cannot be put on hold", "Job on hold cannot be resumed", "Zone ID is already in use", "Invalid zone ID", "Cannot delete non-empty zone object", "No physical component data", "Invalid alarm note ID", "Encryption error", "Invalid mapping table ID"};
    private static final String[] extendedErrorTexts_en = new String[]{"Bad MIB file header", "Bad MIB file data"};
    private static final String[] errorTexts_es = new String[]{"Petici\u00c3\u00b3n completada con \u00c3\u00a9xito", "Componente bloqueado", "Acceso denegado", "Petici\u00c3\u00b3n inv\u00c3\u00a1lida", "Caducidad de la petici\u00c3\u00b3n", "La petici\u00c3\u00b3n est\u00c3\u00a1 fuera de estado", "Fallo en la base de datos", "ID de objeto inv\u00c3\u00a1lido", "El objeto ya existe", "Fallo en la comunicaci\u00c3\u00b3n", "Fallo del sistema", "ID de usuario inv\u00c3\u00a1lido", "Argumento inv\u00c3\u00a1lido", "DCI duplicado", "ID de DCI inv\u00c3\u00a1lido", "Sin memoria", "Error de Entrada/Salida", "Operaci\u00c3\u00b3n incompatible", "La creaci\u00c3\u00b3n del objeto ha fallado", "Se ha detectado un bucle en las relaciones del objeto", "Nombre de objeto inv\u00c3\u00a1lido", "ID de alarma inv\u00c3\u00a1lido", "ID de acci\u00c3\u00b3n inv\u00c3\u00a1lido", "Operaci\u00c3\u00b3n en progreso", "El copiado ha fallado en uno o m\u00c3\u00a1s DCI(s)", "C\u00c3\u00b3digo de evento inv\u00c3\u00a1lido o desconocido", "Sin interfaces adecuados para enviar el paquete m\u00c3\u00a1gico", "Sin direcci\u00c3\u00b3n MAC en el interfaz", "Comando no implementado", "ID de registro de configuraci\u00c3\u00b3n de traps inv\u00c3\u00a1lido", "La petici\u00c3\u00b3n del monitor no est\u00c3\u00a1 soportada por el agente", "Las versiones del cliente y del servidor son incompatibles", "Error al analizar el fichero de informaci\u00c3\u00b3n del paquete", "El paquete con las propiedades especificadas ya est\u00c3\u00a1 instalado en el servidor", "El fichero de paquete ya existe en el servidor", "El recurso del servidor est\u00c3\u00a1 ocupado", "ID de paquete inv\u00c3\u00a1lido", "Direcci\u00c3\u00b3n IP inv\u00c3\u00a1lida", "La acci\u00c3\u00b3n es utilizada en una pol\u00c3\u00adtica de tratamiento de eventos", "Variable no encontrada", "El servidor utiliza un protocolo de comunicaciones incompatible", "La direcci\u00c3\u00b3n ya est\u00c3\u00a1 utilizada", "No es posible seleccionar cifrado", "Clave p\u00c3\u00bablica inv\u00c3\u00a1lida", "Clave de sesi\u00c3\u00b3n inv\u00c3\u00a1lida", "El extremo no soporta cifrado", "Error interno en el servidor", "La ejecuci\u00c3\u00b3n del comando externo ha fallado", "ID de herramienta inv\u00c3\u00a1lido", "Error en el protocolo SNMP", "Expresi\u00c3\u00b3n regular incorrecta", "El par\u00c3\u00a1metro no est\u00c3\u00a1 soportado por el agente", "La operaci\u00c3\u00b3n de E/S del fichero ha fallado", "El fichero MIB est\u00c3\u00a1 corrupto", "La transferencia del fichero est\u00c3\u00a1 en progreso", "ID de tarea inv\u00c3\u00a1lido", "ID de script inv\u00c3\u00a1lido", "Nombre de script inv\u00c3\u00a1lido", "Nombre de mapa desconocido", "ID de mapa inv\u00c3\u00a1lido", "Cuenta desactivada", "No se permiten m\u00c3\u00a1s intentos de conexi\u00c3\u00b3n", "Conexi\u00c3\u00b3n al servidor interrumpida", "ID de configuraci\u00c3\u00b3n del agente inv\u00c3\u00a1lido", "El servidor ha perdido la conexi\u00c3\u00b3n con la base de datos", "La alarma est\u00c3\u00a1 todav\u00c3\u00ada abierta en el sistema de soporte", "La alarma no est\u00c3\u00a1 en estado \"pendiente\"", "El origen de datos del DCI no es un agente de env\u00c3\u00ado", "Error al analizar el fichero para importar la configuraci\u00c3\u00b3n", "La configuraci\u00c3\u00b3n no puede importarse porque existen errores de validaci\u00c3\u00b3n", "ID de gr\u00c3\u00a1fico inv\u00c3\u00a1lido", "Fallo en el proveedor criptogr\u00c3\u00a1fico local", "Tipo de autenticaci\u00c3\u00b3n no soportada", "Certificado da\u00c3\u00b1ado", "ID de certificado inv\u00c3\u00a1lido", "Fallo SNMP", "El nodo no soporta descubrimiento de topolog\u00c3\u00ada en la capa 2", "ID de situaci\u00c3\u00b3n inv\u00c3\u00a1lido", "No se ha encontrado la instancia indicada", "ID de evento inv\u00c3\u00a1lido", "La operaci\u00c3\u00b3n no ha podido ser completada por un error en el agente", "Variable desconocida", "Petici\u00c3\u00b3n de recurso no disponible", "La tarea no puede ser cancelada", "ID de pol\u00c3\u00adtica inv\u00c3\u00a1lido", "Nombre del registro desconocido", "Handle del registro inv\u00c3\u00a1lido", "La nueva contrase\u00c3\u00b1a es demasiado d\u00c3\u00a9bil", "La contrase\u00c3\u00b1a ha sido utilizada anteriormente", "Handle de sesi\u00c3\u00b3n inv\u00c3\u00a1lido", "El nodo ya es miembro de un cluster", "La tarea no puede ser retenida", "La tarea retenida no puede ser reanudada", "El ID de zona ya est\u00c3\u00a1 en uso", "ID de zona inv\u00c3\u00a1lido", "No es posible eliminar zonas con alg\u00c3\u00ban contenido", "Sin datos en el componente f\u00c3\u00adsico", "ID del comentario de la alarma inv\u00c3\u00a1lido", "Error de cifrado", "ID de tabla de asignaci\u00c3\u00b3n inv\u00c3\u00a1lido"};
    private static final String[] extendedErrorTexts_es = new String[]{"Error en la cabecera del fichero MIB", "Error en los datos del fichero MIB"};
    private static final Map<String, String[]> errorTexts = new HashMap<String, String[]>(2);
    private static final Map<String, String[]> extendedErrorTexts;

    public NXCException(int errorCode) {
        super(errorCode);
    }

    public NXCException(int errorCode, String additionalInfo) {
        super(errorCode, additionalInfo);
    }

    protected String getErrorMessage(int code, String lang) {
        try {
            if (code > 1000) {
                String[] texts = extendedErrorTexts.get(lang);
                if (texts == null) {
                    texts = extendedErrorTexts_en;
                }
                return texts[code - 1001];
            }
            String[] texts = errorTexts.get(lang);
            if (texts == null) {
                texts = errorTexts_en;
            }
            return texts[code];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Error " + Integer.toString(code);
        }
    }

    static {
        errorTexts.put("en", errorTexts_en);
        errorTexts.put("es", errorTexts_es);
        extendedErrorTexts = new HashMap<String, String[]>(2);
        extendedErrorTexts.put("en", extendedErrorTexts_en);
        extendedErrorTexts.put("es", extendedErrorTexts_es);
    }
}

