/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClusterNetworkEditDialog
extends Dialog {
    private Text textAddress;
    private Text textMask;
    private InetAddress address;
    private InetAddress mask;

    public ClusterNetworkEditDialog(Shell parentShell, InetAddress address, InetAddress mask) {
        super(parentShell);
        this.address = address;
        this.mask = mask;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Address");
        this.textAddress = new Text(dialogArea, 2052);
        this.textAddress.setTextLimit(15);
        if (this.address != null) {
            this.textAddress.setText(this.address.getHostAddress());
        }
        label = new Label(dialogArea, 0);
        label.setText("");
        label = new Label(dialogArea, 0);
        label.setText("Mask");
        this.textMask = new Text(dialogArea, 2052);
        this.textMask.setTextLimit(15);
        this.textMask.getShell().setMinimumSize(300, 0);
        if (this.mask != null) {
            this.textMask.setText(this.mask.getHostAddress());
        }
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.address == null ? "Add Network" : "Modify Network");
    }

    protected void okPressed() {
        try {
            this.address = InetAddress.getByName(this.textAddress.getText());
            this.mask = InetAddress.getByName(this.textMask.getText());
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter valid IP address and network mask");
            return;
        }
        super.okPressed();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getMask() {
        return this.mask;
    }
}

