/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DialChart;
import org.netxms.ui.eclipse.charts.widgets.GenericChart;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;
import org.netxms.ui.eclipse.shared.SharedColors;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DialChartWidget
extends GenericChart
implements DialChart,
PaintListener,
DisposeListener {
    private static final int OUTER_MARGIN_WIDTH = 5;
    private static final int OUTER_MARGIN_HEIGHT = 5;
    private static final int INNER_MARGIN_WIDTH = 5;
    private static final int INNER_MARGIN_HEIGHT = 5;
    private static final int NEEDLE_PIN_RADIUS = 8;
    private static final int SCALE_OFFSET = 30;
    private static final int SCALE_WIDTH = 10;
    private static final RGB GREEN_ZONE_COLOR = new RGB(0, 224, 0);
    private static final RGB YELLOW_ZONE_COLOR = new RGB(255, 242, 0);
    private static final RGB RED_ZONE_COLOR = new RGB(224, 0, 0);
    private static final RGB NEEDLE_COLOR = new RGB(51, 78, 113);
    private static final RGB NEEDLE_PIN_COLOR = new RGB(239, 228, 176);
    private static Font[] scaleFonts = null;
    private static Font[] valueFonts = null;
    private List<DataComparisonElement> parameters = new ArrayList<DataComparisonElement>(16);
    private Image chartImage = null;
    private ColorCache colors;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private double leftRedZone = 0.0;
    private double leftYellowZone = 0.0;
    private double rightYellowZone = 70.0;
    private double rightRedZone = 90.0;
    private boolean legendInside = true;
    private boolean gridVisible = true;

    public DialChartWidget(Composite parent, int style) {
        super(parent, style | 0x40000);
        if (scaleFonts == null) {
            this.createFonts();
        }
        this.colors = new ColorCache((Control)this);
        this.addPaintListener(this);
        this.addDisposeListener(this);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (DialChartWidget.this.chartImage != null) {
                    DialChartWidget.this.chartImage.dispose();
                    DialChartWidget.this.chartImage = null;
                }
                DialChartWidget.this.refresh();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createFonts() {
        scaleFonts = new Font[16];
        int i = 0;
        while (i < scaleFonts.length) {
            DialChartWidget.scaleFonts[i] = new Font((Device)this.getDisplay(), "Verdana", i + 6, 0);
            ++i;
        }
        valueFonts = new Font[16];
        i = 0;
        while (i < valueFonts.length) {
            DialChartWidget.valueFonts[i] = new Font((Device)this.getDisplay(), "Verdana", i + 6, 1);
            ++i;
        }
    }

    @Override
    public void initializationComplete() {
    }

    private Color getColorFromPreferences(String name) {
        return this.colors.create(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name));
    }

    @Override
    public void setChartTitle(String title) {
        this.title = title;
        this.refresh();
    }

    @Override
    public void setTitleVisible(boolean visible) {
        this.titleVisible = visible;
        this.refresh();
    }

    @Override
    public void setLegendVisible(boolean visible) {
        this.legendVisible = visible;
        this.refresh();
    }

    @Override
    public void set3DModeEnabled(boolean enabled) {
        this.displayIn3D = enabled;
        this.refresh();
    }

    @Override
    public void setLogScaleEnabled(boolean enabled) {
    }

    @Override
    public int addParameter(GraphItem dci, double value) {
        this.parameters.add(new DataComparisonElement(dci, value));
        return this.parameters.size() - 1;
    }

    @Override
    public void updateParameter(int index, double value, boolean updateChart) {
        try {
            this.parameters.get(index).setValue(value);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (updateChart) {
            this.refresh();
        }
    }

    @Override
    public void updateParameterThresholds(int index, Threshold[] thresholds) {
    }

    @Override
    public void setChartType(int chartType) {
    }

    @Override
    public int getChartType() {
        return 4;
    }

    @Override
    public void setTransposed(boolean transposed) {
    }

    @Override
    public boolean isTransposed() {
        return false;
    }

    @Override
    public void setLabelsVisible(boolean visible) {
    }

    @Override
    public boolean isLabelsVisible() {
        return false;
    }

    @Override
    public void setRotation(double angle) {
    }

    @Override
    public double getRotation() {
        return 0.0;
    }

    @Override
    public void refresh() {
        this.render();
        this.redraw();
    }

    @Override
    public void rebuild() {
        this.render();
        this.redraw();
    }

    @Override
    public boolean hasAxes() {
        return false;
    }

    public void paintControl(PaintEvent e) {
        if (this.chartImage != null) {
            e.gc.drawImage(this.chartImage, 0, 0);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
    }

    private void render() {
        Point size = this.getSize();
        if (this.chartImage == null) {
            if (size.x <= 0 || size.y <= 0) {
                return;
            }
            this.chartImage = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.chartImage);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.Background"));
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        int top = 5;
        if (this.titleVisible && this.title != null) {
            gc.setFont(Activator.getDefault().getChartTitleFont());
            gc.setForeground(this.getColorFromPreferences("Chart.Colors.Title"));
            Point ext = gc.textExtent(this.title, 1);
            int x = ext.x < size.x ? (size.x - ext.x) / 2 : 0;
            gc.drawText(this.title, x, top, true);
            top += ext.y + 5;
        }
        if (this.parameters.size() == 0 || size.x < 10 || size.y < 10) {
            gc.dispose();
            return;
        }
        int w = (size.x - 10) / this.parameters.size();
        int h = size.y - 5 - top;
        if (w > 40 * this.parameters.size() && h > 40) {
            int i = 0;
            while (i < this.parameters.size()) {
                this.renderElement(gc, this.parameters.get(i), i * w, top, w, h);
                ++i;
            }
        }
        gc.dispose();
    }

    private void renderElement(GC gc, DataComparisonElement dci, int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        if (this.legendVisible && !this.legendInside) {
            rect.height -= gc.textExtent((String)"MMM").y - 4;
        }
        if (rect.height > rect.width) {
            rect.y += (rect.height - rect.width) / 2;
            rect.height = rect.width;
        } else {
            rect.x += (rect.width - rect.height) / 2;
            rect.width = rect.height;
        }
        double angleValue = (this.maxValue - this.minValue) / 270.0;
        int outerRadius = (rect.width + 1) / 2;
        int scaleOuterOffset = rect.width / 2 * 30 / 100;
        int scaleInnerOffset = rect.width / 2 * 40 / 100;
        int cx = rect.x + rect.width / 2 + 1;
        int cy = rect.y + rect.height / 2 + 1;
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        int startAngle = 225;
        startAngle = this.drawZone(gc, rect, startAngle, this.minValue, this.leftRedZone, angleValue, RED_ZONE_COLOR);
        startAngle = this.drawZone(gc, rect, startAngle, this.leftRedZone, this.leftYellowZone, angleValue, YELLOW_ZONE_COLOR);
        startAngle = this.drawZone(gc, rect, startAngle, this.leftYellowZone, this.rightYellowZone, angleValue, GREEN_ZONE_COLOR);
        startAngle = this.drawZone(gc, rect, startAngle, this.rightYellowZone, this.rightRedZone, angleValue, YELLOW_ZONE_COLOR);
        startAngle = this.drawZone(gc, rect, startAngle, this.rightRedZone, this.maxValue, angleValue, RED_ZONE_COLOR);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.setForeground(SharedColors.BLACK);
        gc.fillArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, 0, 360);
        gc.setLineWidth(2);
        gc.drawArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        gc.setLineWidth(1);
        gc.setForeground(this.getColorFromPreferences("Chart.Axis.X.Color"));
        int textOffset = rect.width / 2 * 30 / 200;
        double arcLength = (double)(outerRadius - scaleOuterOffset) * 4.71238898038469;
        int step = arcLength >= 200.0 ? 27 : 54;
        double valueStep = Math.abs((this.maxValue - this.minValue) / (double)(arcLength >= 200.0 ? 10 : 20));
        int textWidth = (int)(Math.sqrt((outerRadius - scaleOuterOffset) * (outerRadius - scaleOuterOffset) / 2) * 0.7);
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])scaleFonts, (String)"900MM", (int)textWidth, (int)(outerRadius - scaleOuterOffset));
        gc.setFont(markFont);
        int i = 225;
        while (i >= -45) {
            if (this.gridVisible) {
                Point l1 = this.positionOnArc(cx, cy, outerRadius - scaleOuterOffset, i);
                Point l2 = this.positionOnArc(cx, cy, outerRadius - scaleInnerOffset, i);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
            }
            String value = this.roundedMarkValue(i, angleValue, valueStep);
            Point t = this.positionOnArc(cx, cy, outerRadius - textOffset, i);
            Point ext = gc.textExtent(value, 1);
            gc.drawText(value, t.x - ext.x / 2, t.y - ext.y / 2, 1);
            i -= step;
        }
        gc.drawArc(rect.x + scaleOuterOffset, rect.y + scaleOuterOffset, rect.width - scaleOuterOffset * 2, rect.height - scaleOuterOffset * 2, -45, 270);
        gc.drawArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, -45, 270);
        gc.setBackground(this.colors.create(NEEDLE_COLOR));
        double dciValue = dci.getValue();
        if (dciValue < this.minValue) {
            dciValue = this.minValue;
        }
        if (dciValue > this.maxValue) {
            dciValue = this.maxValue;
        }
        int angle = (int)(225.0 - (dciValue - this.minValue) / angleValue);
        Point needleEnd = this.positionOnArc(cx, cy, outerRadius - rect.width / 2 * 5 / 100, angle);
        Point np1 = this.positionOnArc(cx, cy, 4, angle - 90);
        Point np2 = this.positionOnArc(cx, cy, 4, angle + 90);
        gc.fillPolygon(new int[]{np1.x, np1.y, needleEnd.x, needleEnd.y, np2.x, np2.y});
        gc.fillArc(cx - 8, cy - 8, 15, 15, 0, 360);
        gc.setBackground(this.colors.create(NEEDLE_PIN_COLOR));
        gc.fillArc(cx - 4, cy - 4, 7, 7, 0, 360);
        String value = this.getValueAsDisplayString(dci);
        gc.setFont(WidgetHelper.getMatchingSizeFont((Font[])valueFonts, (Font)markFont));
        Point ext = gc.textExtent(value, 1);
        gc.setLineWidth(3);
        gc.setBackground(this.colors.create(NEEDLE_COLOR));
        int boxW = Math.max(outerRadius - scaleInnerOffset - 6, ext.x + 8);
        gc.fillRoundRectangle(cx - boxW / 2, cy + rect.height / 4, boxW, ext.y + 6, 3, 3);
        gc.setForeground(SharedColors.WHITE);
        gc.drawText(value, cx - ext.x / 2, cy + rect.height / 4 + 3, true);
        if (this.legendVisible) {
            ext = gc.textExtent(dci.getName(), 1);
            gc.setForeground(SharedColors.BLACK);
            if (this.legendInside) {
                gc.setFont(markFont);
                gc.drawText(dci.getName(), rect.x + (rect.width - ext.x) / 2, rect.y + scaleInnerOffset / 2 + rect.height / 4, true);
            } else {
                gc.setFont(null);
                gc.drawText(dci.getName(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 4, true);
            }
        }
    }

    private int drawZone(GC gc, Rectangle rect, int startAngle, double minValue, double maxValue, double angleValue, RGB color) {
        if (minValue >= maxValue) {
            return startAngle;
        }
        int angle = (int)((maxValue - minValue) / angleValue);
        if (angle <= 0) {
            return startAngle;
        }
        int offset = rect.width / 2 * 30 / 100;
        gc.setBackground(this.colors.create(color));
        gc.fillArc(rect.x + offset, rect.y + offset, rect.width - offset * 2, rect.height - offset * 2, startAngle, -angle);
        return startAngle - angle;
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }

    private String roundedMarkValue(int angle, double angleValue, double step) {
        double value = (double)(225 - angle) * angleValue + this.minValue;
        double absValue = Math.abs(value);
        if (absValue >= 1.0E10) {
            return String.valueOf(Long.toString(Math.round(value / 1.0E9))) + Messages.DialChartWidget_G;
        }
        if (absValue >= 1.0E9) {
            return String.valueOf(new DecimalFormat("#.#").format(value / 1.0E9)) + Messages.DialChartWidget_G;
        }
        if (absValue >= 1.0E7) {
            return String.valueOf(Long.toString(Math.round(value / 1000000.0))) + Messages.DialChartWidget_M;
        }
        if (absValue >= 1000000.0) {
            return String.valueOf(new DecimalFormat("#.#").format(value / 1000000.0)) + Messages.DialChartWidget_M;
        }
        if (absValue >= 10000.0) {
            return String.valueOf(Long.toString(Math.round(value / 1000.0))) + Messages.DialChartWidget_K;
        }
        if (absValue >= 1000.0) {
            return String.valueOf(new DecimalFormat("#.#").format(value / 1000.0)) + Messages.DialChartWidget_K;
        }
        if (absValue >= 1.0 && step >= 1.0) {
            return Long.toString(Math.round(value));
        }
        if (absValue == 0.0) {
            return "0";
        }
        if (step < 1.0E-5) {
            return Double.toString(value);
        }
        if (step < 1.0E-4) {
            return new DecimalFormat("#.#####").format(value);
        }
        if (step < 0.001) {
            return new DecimalFormat("#.####").format(value);
        }
        if (step < 0.01) {
            return new DecimalFormat("#.###").format(value);
        }
        return new DecimalFormat("#.##").format(value);
    }

    private String getValueAsDisplayString(DataComparisonElement dci) {
        switch (dci.getObject().getDataType()) {
            case 0: {
                return Integer.toString((int)dci.getValue());
            }
            case 1: 
            case 2: 
            case 3: {
                return Long.toString((long)dci.getValue());
            }
        }
        return Double.toString(dci.getValue());
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public double getLeftRedZone() {
        return this.leftRedZone;
    }

    @Override
    public void setLeftRedZone(double leftRedZone) {
        this.leftRedZone = leftRedZone;
    }

    @Override
    public double getLeftYellowZone() {
        return this.leftYellowZone;
    }

    @Override
    public void setLeftYellowZone(double leftYellowZone) {
        this.leftYellowZone = leftYellowZone;
    }

    @Override
    public double getRightYellowZone() {
        return this.rightYellowZone;
    }

    @Override
    public void setRightYellowZone(double rightYellowZone) {
        this.rightYellowZone = rightYellowZone;
    }

    @Override
    public double getRightRedZone() {
        return this.rightRedZone;
    }

    @Override
    public void setRightRedZone(double rightRedZone) {
        this.rightRedZone = rightRedZone;
    }

    @Override
    public boolean isLegendInside() {
        return this.legendInside;
    }

    @Override
    public void setLegendInside(boolean legendInside) {
        this.legendInside = legendInside;
    }

    @Override
    public boolean isGridVisible() {
        return this.gridVisible;
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.gridVisible = visible;
    }

    @Override
    public void setBackgroundColor(ChartColor color) {
    }

    @Override
    public void setPlotAreaColor(ChartColor color) {
    }

    @Override
    public void setLegendColor(ChartColor foreground, ChartColor background) {
    }

    @Override
    public void setAxisColor(ChartColor color) {
    }

    @Override
    public void setGridColor(ChartColor color) {
    }

    @Override
    public void addError(String message) {
    }

    @Override
    public void clearErrors() {
    }
}

