/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MapOptions
extends PropertyPage {
    private NetworkMap object;
    private Button checkShowStatusIcon;
    private Button checkShowStatusFrame;
    private Button checkShowStatusBkgnd;
    private Combo routingAlgorithm;
    private Button radioColorDefault;
    private Button radioColorCustom;
    private ColorSelector linkColor;
    private Button checkIncludeEndNodes;
    private Button checkCustomRadius;
    private Spinner topologyRadius;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (NetworkMap)this.getElement().getAdapter(NetworkMap.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group statusDisplayGroup = new Group(dialogArea, 0);
        statusDisplayGroup.setText("Default display options");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        statusDisplayGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        statusDisplayGroup.setLayout((Layout)layout);
        this.checkShowStatusIcon = new Button((Composite)statusDisplayGroup, 32);
        this.checkShowStatusIcon.setText("Show status &icon");
        this.checkShowStatusIcon.setSelection((this.object.getFlags() & 1) != 0);
        this.checkShowStatusFrame = new Button((Composite)statusDisplayGroup, 32);
        this.checkShowStatusFrame.setText("Show status &frame");
        this.checkShowStatusFrame.setSelection((this.object.getFlags() & 2) != 0);
        this.checkShowStatusBkgnd = new Button((Composite)statusDisplayGroup, 32);
        this.checkShowStatusBkgnd.setText("Show status &background");
        this.checkShowStatusBkgnd.setSelection((this.object.getFlags() & 4) != 0);
        Group linkGroup = new Group(dialogArea, 0);
        linkGroup.setText("Default connection options");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        linkGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        linkGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)linkGroup, (int)8, (String)"Routing algorithm", (Object)gd);
        this.routingAlgorithm.add("Direct");
        this.routingAlgorithm.add("Manhattan");
        this.routingAlgorithm.select(this.object.getDefaultLinkRouting() - 1);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapOptions.this.linkColor.setEnabled(MapOptions.this.radioColorCustom.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioColorDefault = new Button((Composite)linkGroup, 16);
        this.radioColorDefault.setText("&Default color");
        this.radioColorDefault.setSelection(this.object.getDefaultLinkColor() < 0);
        this.radioColorDefault.addSelectionListener(listener);
        gd = new GridData();
        gd.verticalIndent = 8;
        this.radioColorDefault.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)linkGroup, 16);
        this.radioColorCustom.setText("&Custom color");
        this.radioColorCustom.setSelection(this.object.getDefaultLinkColor() >= 0);
        this.radioColorCustom.addSelectionListener(listener);
        this.linkColor = new ColorSelector((Composite)linkGroup);
        this.linkColor.setColorValue(ColorConverter.rgbFromInt((int)this.object.getDefaultLinkColor()));
        this.linkColor.setEnabled(this.object.getDefaultLinkColor() >= 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.linkColor.getButton().setLayoutData((Object)gd);
        if (this.object.getMapType() != 0) {
            Group topoGroup = new Group(dialogArea, 0);
            topoGroup.setText("Topology options");
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            topoGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            topoGroup.setLayout((Layout)layout);
            this.checkIncludeEndNodes = new Button((Composite)topoGroup, 32);
            this.checkIncludeEndNodes.setText("Include &end nodes");
            this.checkIncludeEndNodes.setSelection((this.object.getFlags() & 8) != 0);
            this.checkCustomRadius = new Button((Composite)topoGroup, 32);
            this.checkCustomRadius.setText("Custom discovery &radius");
            this.checkCustomRadius.setSelection(this.object.getDiscoveryRadius() > 0);
            this.checkCustomRadius.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MapOptions.this.topologyRadius.setEnabled(MapOptions.this.checkCustomRadius.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.topologyRadius = WidgetHelper.createLabeledSpinner((Composite)topoGroup, (int)2048, (String)"Topology discovery radius", (int)1, (int)255, (Object)"WidgetHelper::default_layout_data");
            this.topologyRadius.setSelection(this.object.getDiscoveryRadius());
            this.topologyRadius.setEnabled(this.object.getDiscoveryRadius() > 0);
        }
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        int flags = 0;
        if (this.checkIncludeEndNodes != null && this.checkIncludeEndNodes.getSelection()) {
            flags |= 8;
        }
        if (this.checkShowStatusIcon.getSelection()) {
            flags |= 1;
        }
        if (this.checkShowStatusFrame.getSelection()) {
            flags |= 2;
        }
        if (this.checkShowStatusBkgnd.getSelection()) {
            flags |= 4;
        }
        md.setObjectFlags(flags);
        md.setConnectionRouting(this.routingAlgorithm.getSelectionIndex() + 1);
        if (this.radioColorCustom.getSelection()) {
            md.setLinkColor(ColorConverter.rgbToInt((RGB)this.linkColor.getColorValue()));
        } else {
            md.setLinkColor(-1);
        }
        if (this.checkCustomRadius != null) {
            if (this.checkCustomRadius.getSelection()) {
                md.setDiscoveryRadius(this.topologyRadius.getSelection());
            } else {
                md.setDiscoveryRadius(-1);
            }
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update map options for map object " + this.object.getObjectName(), null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot modify options for map object " + MapOptions.this.object.getObjectName();
            }

            protected void jobFinalize() {
                if (isApply) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MapOptions.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

