/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.algorithms.ExpansionAlgorithm;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.views.helpers.BendpointEditor;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigureType;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public abstract class NetworkMap
extends ViewPart
implements ISelectionProvider,
IZoomableWorkbenchPart {
    protected static final int LAYOUT_SPRING = 0;
    protected static final int LAYOUT_RADIAL = 1;
    protected static final int LAYOUT_HTREE = 2;
    protected static final int LAYOUT_VTREE = 3;
    protected static final int LAYOUT_SPARSE_VTREE = 4;
    private static final String[] layoutAlgorithmNames = new String[]{"&Spring", "&Radial", "&Horizontal tree", "&Vertical tree", "S&parse vertical tree"};
    private static final String[] connectionRouterNames = new String[]{"&Direct", "&Manhattan"};
    private static final int SELECTION_EMPTY = 0;
    private static final int SELECTION_MIXED = 1;
    private static final int SELECTION_OBJECTS = 2;
    private static final int SELECTION_ELEMENTS = 3;
    private static final int SELECTION_LINKS = 4;
    protected NXCSession session;
    protected GenericObject rootObject;
    protected NetworkMapPage mapPage;
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    protected int layoutAlgorithm = 0;
    protected int routingAlgorithm = 1;
    protected boolean allowManualLayout = false;
    protected boolean automaticLayoutEnabled = true;
    private RefreshAction actionRefresh;
    private Action actionShowStatusIcon;
    private Action actionShowStatusBackground;
    private Action actionShowStatusFrame;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action[] actionZoomTo;
    private Action[] actionSetAlgorithm;
    private Action[] actionSetRouter;
    private Action actionEnableAutomaticLayout;
    private Action actionSaveLayout;
    private Action actionOpenSubmap;
    private Action actionFiguresIcons;
    private Action actionFiguresSmallLabels;
    private Action actionFiguresLargeLabels;
    private Action actionShowGrid;
    private Action actionAlignToGrid;
    private Action actionSnapToGrid;
    private String viewId;
    private IStructuredSelection currentSelection = new StructuredSelection(new Object[0]);
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private BendpointEditor bendpointEditor = null;
    private SessionListener sessionListener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        this.rootObject = this.session.findObjectById(Long.parseLong(parts.length > 0 ? parts[0] : site.getSecondaryId()));
        if (this.rootObject == null) {
            throw new PartInitException("Root object for this map is no longer exist or is not accessible");
        }
        this.viewId = String.valueOf(site.getId()) + ".";
        this.viewId = String.valueOf(this.viewId) + (parts.length > 0 ? parts[0] : site.getSecondaryId());
        this.parseSecondaryId(parts);
    }

    protected void parseSecondaryId(String[] parts) throws PartInitException {
    }

    protected abstract void buildMapPage();

    public void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new ExtendedGraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            this.labelProvider.setObjectFigureType(ObjectFigureType.values()[settings.getInt(String.valueOf(this.viewId) + ".objectFigureType")]);
        }
        catch (Exception exception) {}
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (NetworkMap.this.bendpointEditor != null) {
                    NetworkMap.this.bendpointEditor.stop();
                    NetworkMap.this.bendpointEditor = null;
                }
                NetworkMap.this.currentSelection = NetworkMap.this.transformSelection(e.getSelection());
                if (NetworkMap.this.currentSelection.size() == 1) {
                    int selectionType = NetworkMap.this.analyzeSelection(NetworkMap.this.currentSelection);
                    if (selectionType == 2) {
                        GenericObject object = (GenericObject)NetworkMap.this.currentSelection.getFirstElement();
                        NetworkMap.this.actionOpenSubmap.setEnabled(object.getSubmapId() != 0L);
                    } else {
                        NetworkMapLink link;
                        NetworkMap.this.actionOpenSubmap.setEnabled(false);
                        if (selectionType == 4 && (link = (NetworkMapLink)NetworkMap.this.currentSelection.getFirstElement()).getRouting() == 3) {
                            NetworkMap.this.bendpointEditor = new BendpointEditor(link, (GraphConnection)NetworkMap.this.viewer.getGraphControl().getSelection().get(0), NetworkMap.this.viewer);
                        }
                    }
                } else {
                    NetworkMap.this.actionOpenSubmap.setEnabled(false);
                }
                if (NetworkMap.this.selectionListeners.isEmpty()) {
                    return;
                }
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)NetworkMap.this, (ISelection)NetworkMap.this.currentSelection);
                for (ISelectionChangedListener l : NetworkMap.this.selectionListeners) {
                    l.selectionChanged(event);
                }
            }
        };
        this.viewer.addPostSelectionChangedListener(listener);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkMap.this.actionOpenSubmap.run();
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4) {
                    NetworkMap.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NetworkMap.this.onObjectChange((GenericObject)n.getObject());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.automaticLayoutEnabled) {
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        } else {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        }
        this.refreshMap();
    }

    protected void refreshMap() {
        this.buildMapPage();
        this.viewer.setInput(this.mapPage);
    }

    protected void replaceMapPage(final NetworkMapPage page, Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                NetworkMap.this.mapPage = page;
                NetworkMap.this.viewer.setInput(NetworkMap.this.mapPage);
            }
        });
    }

    protected void setLayoutAlgorithm(int alg, boolean forceChange) {
        SpringLayoutAlgorithm algorithm;
        if (alg == Short.MAX_VALUE) {
            if (!this.automaticLayoutEnabled) {
                return;
            }
            this.automaticLayoutEnabled = false;
            this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(false);
            this.actionEnableAutomaticLayout.setChecked(false);
            return;
        }
        if (this.automaticLayoutEnabled && alg == this.layoutAlgorithm && !forceChange) {
            return;
        }
        if (!this.automaticLayoutEnabled) {
            this.actionEnableAutomaticLayout.setChecked(true);
            this.automaticLayoutEnabled = true;
        }
        switch (alg) {
            case 0: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case 1: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case 2: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case 3: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case 4: {
                algorithm = new TreeLayoutAlgorithm(1);
                ((TreeLayoutAlgorithm)algorithm).setNodeSpace(new Dimension(100, 100));
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{algorithm, new ExpansionAlgorithm()}));
        this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(false);
        this.layoutAlgorithm = alg;
        this.actionSetAlgorithm[this.layoutAlgorithm].setChecked(true);
    }

    protected void updateObjectPositions() {
        Graph graph = this.viewer.getGraphControl();
        List nodes = graph.getNodes();
        for (Object o : nodes) {
            Object data;
            if (!(o instanceof GraphNode) || !((data = ((GraphNode)o).getData()) instanceof NetworkMapElement)) continue;
            Point loc = ((GraphNode)o).getLocation();
            Dimension size = ((GraphNode)o).getSize();
            ((NetworkMapElement)data).setLocation(loc.x + (size.width + 1) / 2, loc.y + (size.height + 1) / 2);
        }
    }

    protected void setManualLayout() {
        this.updateObjectPositions();
        this.automaticLayoutEnabled = false;
        this.viewer.setLayoutAlgorithm(new ManualLayout(), true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(false);
            ++i;
        }
        this.actionSaveLayout.setEnabled(true);
    }

    protected void setAutomaticLayout() {
        this.automaticLayoutEnabled = true;
        this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(true);
            ++i;
        }
        this.actionSaveLayout.setEnabled(false);
    }

    protected void createActions() {
        int alg;
        this.actionRefresh = new RefreshAction(){

            public void run() {
                NetworkMap.this.refreshMap();
            }
        };
        this.actionShowStatusBackground = new Action("Show status &background", 2){

            public void run() {
                NetworkMap.this.labelProvider.setShowStatusBackground(!NetworkMap.this.labelProvider.isShowStatusBackground());
                this.setChecked(NetworkMap.this.labelProvider.isShowStatusBackground());
                NetworkMap.this.viewer.refresh();
            }
        };
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusBackground.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        this.actionShowStatusIcon = new Action("Show status &icon", 2){

            public void run() {
                NetworkMap.this.labelProvider.setShowStatusIcons(!NetworkMap.this.labelProvider.isShowStatusIcons());
                this.setChecked(NetworkMap.this.labelProvider.isShowStatusIcons());
                NetworkMap.this.viewer.refresh();
            }
        };
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowStatusIcon.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        this.actionShowStatusFrame = new Action("Show status &frame", 2){

            public void run() {
                NetworkMap.this.labelProvider.setShowStatusFrame(!NetworkMap.this.labelProvider.isShowStatusFrame());
                this.setChecked(NetworkMap.this.labelProvider.isShowStatusFrame());
                NetworkMap.this.viewer.refresh();
            }
        };
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusFrame.setEnabled(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        this.actionZoomIn = new Action("Zoom &in"){

            public void run() {
                NetworkMap.this.viewer.zoomIn();
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action("Zoom &out"){

            public void run() {
                NetworkMap.this.viewer.zoomOut();
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.actionZoomTo = this.viewer.createZoomActions();
        this.actionSetAlgorithm = new Action[layoutAlgorithmNames.length];
        int i = 0;
        while (i < layoutAlgorithmNames.length) {
            alg = i;
            this.actionSetAlgorithm[i] = new Action(layoutAlgorithmNames[i], 8){

                public void run() {
                    NetworkMap.this.setLayoutAlgorithm(alg, true);
                    NetworkMap.this.viewer.setInput(NetworkMap.this.mapPage);
                }
            };
            this.actionSetAlgorithm[i].setChecked(this.layoutAlgorithm == i);
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
            ++i;
        }
        this.actionSetRouter = new Action[connectionRouterNames.length];
        i = 0;
        while (i < connectionRouterNames.length) {
            alg = i + 1;
            this.actionSetRouter[i] = new Action(connectionRouterNames[i], 8){

                public void run() {
                    NetworkMap.this.setConnectionRouter(alg);
                }
            };
            this.actionSetRouter[i].setChecked(this.routingAlgorithm == alg);
            ++i;
        }
        this.actionEnableAutomaticLayout = new Action("Enable &automatic layout", 2){

            public void run() {
                if (NetworkMap.this.automaticLayoutEnabled) {
                    NetworkMap.this.setManualLayout();
                } else {
                    NetworkMap.this.setAutomaticLayout();
                }
                this.setChecked(NetworkMap.this.automaticLayoutEnabled);
            }
        };
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
        this.actionSaveLayout = new Action("&Save layout"){

            public void run() {
                NetworkMap.this.updateObjectPositions();
                NetworkMap.this.saveLayout();
            }
        };
        this.actionSaveLayout.setImageDescriptor(SharedIcons.SAVE);
        this.actionSaveLayout.setEnabled(!this.automaticLayoutEnabled);
        this.actionOpenSubmap = new Action("Open s&ubmap"){

            public void run() {
                NetworkMap.this.openSubmap();
            }
        };
        this.actionOpenSubmap.setEnabled(false);
        this.actionFiguresIcons = new Action("&Icons", 8){

            public void run() {
                NetworkMap.this.labelProvider.setObjectFigureType(ObjectFigureType.ICON);
                NetworkMap.this.viewer.refresh(true);
                NetworkMap.this.actionShowStatusBackground.setEnabled(true);
                NetworkMap.this.actionShowStatusFrame.setEnabled(true);
                NetworkMap.this.actionShowStatusIcon.setEnabled(true);
            }
        };
        this.actionFiguresIcons.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.ICON);
        this.actionFiguresSmallLabels = new Action("&Small labels", 8){

            public void run() {
                NetworkMap.this.labelProvider.setObjectFigureType(ObjectFigureType.SMALL_LABEL);
                NetworkMap.this.viewer.refresh(true);
                NetworkMap.this.actionShowStatusBackground.setEnabled(false);
                NetworkMap.this.actionShowStatusFrame.setEnabled(false);
                NetworkMap.this.actionShowStatusIcon.setEnabled(false);
            }
        };
        this.actionFiguresSmallLabels.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.SMALL_LABEL);
        this.actionFiguresLargeLabels = new Action("&Large labels", 8){

            public void run() {
                NetworkMap.this.labelProvider.setObjectFigureType(ObjectFigureType.LARGE_LABEL);
                NetworkMap.this.viewer.refresh(true);
                NetworkMap.this.actionShowStatusBackground.setEnabled(false);
                NetworkMap.this.actionShowStatusFrame.setEnabled(false);
                NetworkMap.this.actionShowStatusIcon.setEnabled(false);
            }
        };
        this.actionFiguresLargeLabels.setChecked(this.labelProvider.getObjectFigureType() == ObjectFigureType.LARGE_LABEL);
        this.actionShowGrid = new Action("Show &grid", 2){

            public void run() {
                NetworkMap.this.viewer.showGrid(NetworkMap.this.actionShowGrid.isChecked());
            }
        };
        this.actionShowGrid.setImageDescriptor(Activator.getImageDescriptor("icons/grid.png"));
        this.actionShowGrid.setChecked(this.viewer.isGridVisible());
        this.actionSnapToGrid = new Action("S&nap to grid", 2){

            public void run() {
                NetworkMap.this.viewer.setSnapToGrid(NetworkMap.this.actionSnapToGrid.isChecked());
            }
        };
        this.actionSnapToGrid.setImageDescriptor(Activator.getImageDescriptor("icons/snap_to_grid.png"));
        this.actionSnapToGrid.setChecked(this.viewer.isSnapToGrid());
        this.actionAlignToGrid = new Action("&Align to grid", Activator.getImageDescriptor("icons/align_to_grid.gif")){

            public void run() {
                NetworkMap.this.viewer.alignToGrid(false);
                NetworkMap.this.updateObjectPositions();
            }
        };
    }

    protected IContributionItem createLayoutSubmenu() {
        MenuManager layout = new MenuManager("&Layout");
        if (this.allowManualLayout) {
            layout.add((IAction)this.actionEnableAutomaticLayout);
            layout.add((IContributionItem)new Separator());
        }
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            layout.add((IAction)this.actionSetAlgorithm[i]);
            ++i;
        }
        if (this.allowManualLayout) {
            layout.add((IContributionItem)new Separator());
            layout.add((IAction)this.actionSaveLayout);
        }
        return layout;
    }

    protected IContributionItem createRoutingSubmenu() {
        MenuManager submenu = new MenuManager("&Routing");
        int i = 0;
        while (i < this.actionSetRouter.length) {
            submenu.add((IAction)this.actionSetRouter[i]);
            ++i;
        }
        return submenu;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager zoom = new MenuManager("&Zoom");
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        MenuManager figureType = new MenuManager("&Display objects as");
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        if (this.allowManualLayout) {
            manager.add((IAction)this.actionSaveLayout);
        }
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int selType = NetworkMap.this.analyzeSelection(NetworkMap.this.currentSelection);
                switch (selType) {
                    case 0: {
                        NetworkMap.this.fillMapContextMenu(manager);
                        break;
                    }
                    case 2: {
                        NetworkMap.this.fillObjectContextMenu(manager);
                        break;
                    }
                    case 3: {
                        NetworkMap.this.fillElementContextMenu(manager);
                        break;
                    }
                    case 4: {
                        NetworkMap.this.fillLinkContextMenu(manager);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    protected void fillObjectContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionOpenSubmap);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("nxvs"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        if (this.currentSelection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker("properties"));
            manager.add((IAction)new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this));
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        MenuManager zoom = new MenuManager("&Zoom");
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        MenuManager figureType = new MenuManager("&Display objects as");
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int analyzeSelection(IStructuredSelection selection) {
        Class<GenericObject> firstClass;
        int type;
        if (selection.isEmpty()) {
            return 0;
        }
        Iterator it = selection.iterator();
        Object first = it.next();
        if (first instanceof GenericObject) {
            type = 2;
            firstClass = GenericObject.class;
        } else if (first instanceof NetworkMapElement) {
            type = 3;
            firstClass = NetworkMapElement.class;
        } else {
            if (!(first instanceof NetworkMapLink)) {
                return 1;
            }
            type = 4;
            firstClass = NetworkMapLink.class;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (firstClass.isInstance(o)) continue;
            return 1;
        }
        return type;
    }

    protected void onObjectChange(GenericObject object) {
        List links;
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh(element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh(l);
            }
        }
        if (object.getObjectId() == this.rootObject.getObjectId()) {
            this.rootObject = object;
        }
    }

    protected void saveLayout() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.labelProvider != null) {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put(String.valueOf(this.viewId) + ".objectFigureType", this.labelProvider.getObjectFigureType().ordinal());
        }
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    private IStructuredSelection transformSelection(ISelection viewerSelection) {
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        if (selection.isEmpty()) {
            return selection;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object element : selection) {
            if (element instanceof NetworkMapObject) {
                GenericObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
                if (object != null) {
                    objects.add(object);
                    continue;
                }
                objects.add(element);
                continue;
            }
            if (!this.isSelectableElement(element)) continue;
            objects.add(element);
        }
        return new StructuredSelection(objects.toArray());
    }

    protected boolean isSelectableElement(Object element) {
        return false;
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    private void openSubmap() {
        long submapId;
        if (this.currentSelection == null) {
            return;
        }
        Object object = this.currentSelection.getFirstElement();
        if (object instanceof GenericObject && (submapId = ((GenericObject)object).getSubmapId()) != 0L) {
            try {
                this.getSite().getPage().showView("org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(submapId), 1);
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Cannot open submap view: " + e.getMessage()));
            }
        }
    }

    public void setConnectionRouter(int routingAlgorithm) {
        switch (routingAlgorithm) {
            case 2: {
                routingAlgorithm = 2;
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                routingAlgorithm = 1;
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        int i = 0;
        while (i < this.actionSetRouter.length) {
            this.actionSetRouter[i].setChecked(routingAlgorithm == i + 1);
            ++i;
        }
        this.viewer.refresh();
    }
}

