/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableComparisonChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class TableComparisonChartElement
extends ElementWidget {
    protected DataComparisonChart chart;
    protected NXCSession session;
    protected int refreshInterval = 30000;
    protected TableComparisonChartConfig config;
    private Runnable refreshTimer;
    private boolean updateInProgress = false;
    private Map<String, Integer> instanceMap = new HashMap<String, Integer>(16);
    private boolean chartInitialized = false;

    public TableComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.setLayout((Layout)new FillLayout());
    }

    protected void startRefreshTimer() {
        if (this.config == null || this.config.getDataColumn() == null) {
            return;
        }
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (TableComparisonChartElement.this.isDisposed()) {
                    return;
                }
                TableComparisonChartElement.this.refreshData();
                display.timerExec(TableComparisonChartElement.this.refreshInterval, (Runnable)this);
            }
        };
        display.timerExec(this.refreshInterval, this.refreshTimer);
        this.refreshData();
    }

    protected void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob(Messages.TableComparisonChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table data = TableComparisonChartElement.this.session.getTableLastValues(TableComparisonChartElement.this.config.getNodeId(), TableComparisonChartElement.this.config.getDciId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((Widget)(this).TableComparisonChartElement.this.chart).isDisposed()) {
                            TableComparisonChartElement.this.updateChart(data);
                        }
                        TableComparisonChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.TableComparisonChartElement_JobError;
            }

            protected void jobFailureHandler() {
                TableComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    private void updateChart(Table data) {
        String instanceColumn;
        String string = instanceColumn = this.config.getInstanceColumn() != null ? this.config.getInstanceColumn() : data.getInstanceColumn();
        if (instanceColumn == null) {
            return;
        }
        int icIndex = data.getColumnIndex(instanceColumn);
        int dcIndex = data.getColumnIndex(this.config.getDataColumn());
        if (icIndex == -1 || dcIndex == -1) {
            return;
        }
        boolean rebuild = false;
        int i = 0;
        while (i < data.getRowCount()) {
            block12: {
                Integer index;
                double value;
                block13: {
                    String instance = data.getCell(i, icIndex);
                    if (instance == null) break block12;
                    try {
                        value = Double.parseDouble(data.getCell(i, dcIndex));
                    }
                    catch (NumberFormatException numberFormatException) {
                        value = 0.0;
                    }
                    index = this.instanceMap.get(instance);
                    if (index != null) break block13;
                    if (this.instanceMap.size() >= 16 || value == 0.0 && this.config.isIgnoreZeroValues()) break block12;
                    index = this.chart.addParameter(new GraphItem(this.config.getNodeId(), this.config.getDciId(), 0, 0, Long.toString(this.config.getDciId()), instance), 0.0);
                    this.instanceMap.put(instance, index);
                    rebuild = true;
                }
                this.chart.updateParameter(index.intValue(), value, false);
            }
            ++i;
        }
        if (!this.chartInitialized) {
            this.chart.initializationComplete();
            this.chartInitialized = true;
        } else if (rebuild) {
            this.chart.rebuild();
        } else {
            this.chart.refresh();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }
}

