/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmNote;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.EditCommentDialog;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeContentProvider;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCommentsEditor;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AlarmDetails
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmDetails";
    public static final int EV_COLUMN_SEVERITY = 0;
    public static final int EV_COLUMN_SOURCE = 1;
    public static final int EV_COLUMN_NAME = 2;
    public static final int EV_COLUMN_MESSAGE = 3;
    public static final int EV_COLUMN_TIMESTAMP = 4;
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/terminated.png"};
    private static final String[] stateText = new String[]{Messages.AlarmListLabelProvider_AlarmState_Outstanding, Messages.AlarmListLabelProvider_AlarmState_Acknowledged, Messages.AlarmListLabelProvider_AlarmState_Terminated};
    private NXCSession session;
    private long alarmId;
    private ImageCache imageCache;
    private WorkbenchLabelProvider wbLabelProvider;
    private ScrolledComposite scroller;
    private Composite formContainer;
    private FormToolkit toolkit;
    private Form form;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private Label alarmText;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap<Long, AlarmCommentsEditor>();
    private Composite dataArea;
    private LastValuesWidget lastValuesWidget = null;
    private SortableTreeViewer eventViewer;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.wbLabelProvider = new WorkbenchLabelProvider();
        try {
            this.alarmId = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            throw new PartInitException(Messages.AlarmComments_InternalError, (Throwable)e);
        }
        this.setPartName(String.valueOf(this.getPartName()) + " [" + Long.toString(this.alarmId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ImageCache();
        this.scroller = new ScrolledComposite(parent, 512);
        this.scroller.setExpandVertical(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.formContainer = new Composite((Composite)this.scroller, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        this.formContainer.setLayout((Layout)containerLayout);
        this.scroller.setContent((Control)this.formContainer);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = AlarmDetails.this.scroller.getClientArea();
                Point formSize = AlarmDetails.this.formContainer.computeSize(r.width, -1);
                AlarmDetails.this.formContainer.setSize(r.width, formSize.y);
                AlarmDetails.this.scroller.setMinHeight(formSize.y);
            }
        });
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(this.formContainer);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.form.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createAlarmDetailsSection();
        this.createEventsSection();
        this.createCommentsSection();
        this.createDataSection();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AlarmDetails.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createAlarmDetailsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        section.setText("Overview");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.alarmSeverity = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSeverity);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmSeverity.setLayoutData((Object)gd);
        this.alarmState = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmState);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSource);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmSource.setLayoutData((Object)gd);
        this.alarmText = this.toolkit.createLabel(clientArea, "", 64);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmText.setLayoutData((Object)gd);
    }

    private void createCommentsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        section.setText(Messages.AlarmComments_Comments);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        section.setLayoutData((Object)gd);
        this.editorsArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        section.setClient((Control)this.editorsArea);
        this.linkAddComment = this.toolkit.createImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/new_comment.png")));
        this.linkAddComment.setText(Messages.AlarmComments_AddCommentLink);
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmDetails.this.addComment();
            }
        });
    }

    private void createEventsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        section.setText("Related Events");
        final GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                gd.grabExcessVerticalSpace = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        String[] names = new String[]{"Severity", "Source", "Name", "Message", "Timestamp"};
        int[] widths = new int[]{130, 160, 160, 400, 120};
        this.eventViewer = new SortableTreeViewer((Composite)section, names, widths, 0, 128, 67584);
        section.setClient(this.eventViewer.getControl());
        this.eventViewer.setContentProvider((IContentProvider)new EventTreeContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new EventTreeLabelProvider());
    }

    private void createDataSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        section.setText("Last Values");
        final GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                gd.grabExcessVerticalSpace = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        this.dataArea = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)this.dataArea);
        this.dataArea.setLayout((Layout)new FillLayout());
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void refresh() {
        new ConsoleJob("Reading alarm details", (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Alarm alarm = AlarmDetails.this.session.getAlarm(AlarmDetails.this.alarmId);
                final List comments = AlarmDetails.this.session.getAlarmNotes(AlarmDetails.this.alarmId);
                final List events = AlarmDetails.this.session.getAlarmEvents(AlarmDetails.this.alarmId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GenericObject object;
                        AlarmDetails.this.updateAlarmDetails(alarm);
                        for (AlarmCommentsEditor e : AlarmDetails.this.editors.values()) {
                            e.dispose();
                        }
                        for (AlarmNote n : comments) {
                            AlarmDetails.this.editors.put(n.getId(), AlarmDetails.this.createEditor(n));
                        }
                        if (AlarmDetails.this.lastValuesWidget == null && (object = AlarmDetails.this.session.findObjectById(alarm.getSourceObjectId())) != null) {
                            AlarmDetails.this.lastValuesWidget = new LastValuesWidget((ViewPart)AlarmDetails.this, AlarmDetails.this.dataArea, 2048, object, "AlarmDetails.LastValues");
                            AlarmDetails.this.lastValuesWidget.refresh();
                        }
                        AlarmDetails.this.eventViewer.setInput((Object)events);
                        AlarmDetails.this.eventViewer.expandAll();
                        AlarmDetails.this.updateLayout();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get alarm details from server";
            }
        }.start();
    }

    private void updateLayout() {
        this.formContainer.layout(true, true);
        Rectangle r = this.scroller.getClientArea();
        Point formSize = this.formContainer.computeSize(r.width, -1);
        this.formContainer.setSize(r.width, formSize.y);
        this.scroller.setMinHeight(formSize.y);
    }

    private AlarmCommentsEditor createEditor(AlarmNote note) {
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.toolkit, this.imageCache, note);
        this.toolkit.adapt((Composite)e);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData(gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        final EditCommentDialog dlg = new EditCommentDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob(Messages.AlarmComments_AddCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmDetails.this.session.updateAlarmNote(AlarmDetails.this.alarmId, 0L, dlg.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmDetails.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.AlarmComments_AddError;
            }
        }.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((int)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((int)alarm.getCurrentSeverity()));
        this.alarmState.setImage(this.imageCache.add(Activator.getImageDescriptor(stateImage[alarm.getState()])));
        this.alarmState.setText(stateText[alarm.getState()]);
        GenericObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]");
        this.alarmText.setText(alarm.getMessage());
    }

    public void dispose() {
        this.imageCache.dispose();
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

