/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.api.ConsoleLoginListener;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;

public class LoginListener
implements ConsoleLoginListener {
    public void afterLogin(final NXCSession session, final Display display) {
        ImageProvider.createInstance(display, session);
        Job job = new Job("Initialize image library"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ImageProvider.getInstance().syncMetaData();
                    session.addListener((SessionListener)new ImageLibraryListener(display, session));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private final class ImageLibraryListener
    implements SessionListener {
        private final Display display;
        private final NXCSession session;

        private ImageLibraryListener(Display display, NXCSession session) {
            this.display = display;
            this.session = session;
        }

        public void notificationHandler(SessionNotification n) {
            if (n.getCode() == 11) {
                UUID guid = (UUID)n.getObject();
                ImageProvider imageProvider = ImageProvider.getInstance();
                imageProvider.invalidateImage(guid, n.getSubCode() == 1022L);
            }
        }
    }
}

