/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.views;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.api.client.ProgressListener;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.netxms.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.netxms.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.Gallery;
import org.netxms.nebula.widgets.gallery.GalleryItem;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImagePropertiesDialog;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class ImageLibrary
extends ViewPart
implements ImageUpdateListener {
    public static final String ID = "org.netxms.ui.eclipse.imagelibrary.view.imagelibrary";
    protected static final int MIN_GRID_ICON_SIZE = 48;
    protected static final int MAX_GRID_ICON_SIZE = 256;
    private Gallery gallery;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionRefresh;
    private Action actionZoomIn;
    private Action actionZoomOut;
    protected MenuDetectEvent menuEvent;
    private NXCSession session;
    private Set<String> knownCategories;
    protected int currentIconSize = 48;

    public void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.gallery = new Gallery(parent, 514);
        DefaultGalleryGroupRenderer galleryGroupRenderer = new DefaultGalleryGroupRenderer();
        galleryGroupRenderer.setMinMargin(2);
        galleryGroupRenderer.setItemHeight(48);
        galleryGroupRenderer.setItemWidth(48);
        galleryGroupRenderer.setAutoMargin(true);
        galleryGroupRenderer.setAlwaysExpanded(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)galleryGroupRenderer);
        DefaultGalleryItemRenderer itemRenderer = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)itemRenderer);
        this.createActions();
        this.createPopupMenu();
        this.contributeToActionBars();
        this.gallery.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ImageLibrary.this.menuEvent = e;
            }
        });
        try {
            this.refreshImages();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ImageProvider.getInstance().addUpdateListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageProvider.getInstance().removeUpdateListener(ImageLibrary.this);
            }
        });
    }

    public void setFocus() {
    }

    private void createActions() {
        this.actionNew = new Action("&Upload New Image"){

            public void run() {
                ImagePropertiesDialog dialog = new ImagePropertiesDialog(ImageLibrary.this.getSite().getShell(), ImageLibrary.this.knownCategories);
                GalleryItem[] selection = ImageLibrary.this.gallery.getSelection();
                if (selection.length > 0) {
                    LibraryImage image = (LibraryImage)selection[0].getData();
                    dialog.setDefaultCategory(image.getCategory());
                }
                if (dialog.open() == 0) {
                    ImageLibrary.this.uploadNewImage(dialog.getName(), dialog.getCategory(), dialog.getFileName());
                }
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new Action("&Edit"){

            public void run() {
                GalleryItem[] selection = ImageLibrary.this.gallery.getSelection();
                if (selection.length == 1) {
                    ImagePropertiesDialog dialog = new ImagePropertiesDialog(ImageLibrary.this.getSite().getShell(), ImageLibrary.this.knownCategories);
                    LibraryImage image = (LibraryImage)selection[0].getData();
                    dialog.setName(image.getName());
                    dialog.setDefaultCategory(image.getCategory());
                    if (dialog.open() == 0) {
                        ImageLibrary.this.editImage(selection[0], dialog.getName(), dialog.getCategory(), dialog.getFileName());
                    }
                }
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionDelete = new Action("&Delete"){

            public void run() {
                ImageLibrary.this.deleteImage();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        this.actionRefresh = new Action("&Refresh"){

            public void run() {
                try {
                    ImageLibrary.this.refreshImages();
                }
                catch (Exception e) {
                    Activator.logError("ImageLibrary view: Exception in refresh action", e);
                }
            }
        };
        this.actionRefresh.setImageDescriptor(SharedIcons.REFRESH);
        this.actionZoomIn = new Action("Zoom In"){

            public void run() {
                DefaultGalleryGroupRenderer groupRenderer = (DefaultGalleryGroupRenderer)ImageLibrary.this.gallery.getGroupRenderer();
                if (ImageLibrary.this.currentIconSize < 256) {
                    ImageLibrary.this.currentIconSize += 16;
                    groupRenderer.setItemHeight(ImageLibrary.this.currentIconSize);
                    groupRenderer.setItemWidth(ImageLibrary.this.currentIconSize);
                }
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action("Zoom Out"){

            public void run() {
                DefaultGalleryGroupRenderer groupRenderer = (DefaultGalleryGroupRenderer)ImageLibrary.this.gallery.getGroupRenderer();
                if (ImageLibrary.this.currentIconSize > 48) {
                    ImageLibrary.this.currentIconSize -= 16;
                    groupRenderer.setItemHeight(ImageLibrary.this.currentIconSize);
                    groupRenderer.setItemWidth(ImageLibrary.this.currentIconSize);
                }
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
    }

    protected void editImage(GalleryItem galleryItem, final String name, final String category, final String fileName) {
        final LibraryImage image = (LibraryImage)galleryItem.getData();
        new ConsoleJob("Update image", (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                if (fileName != null) {
                    FileInputStream stream = null;
                    try {
                        long fileSize = new File(fileName).length();
                        stream = new FileInputStream(fileName);
                        byte[] imageData = new byte[(int)fileSize];
                        stream.read(imageData);
                        image.setBinaryData(imageData);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (!image.isProtected()) {
                    image.setName(name);
                    image.setCategory(category);
                }
                ImageLibrary.this.session.modifyImage(image, new ProgressListener(){
                    private long prevDone = 0L;

                    public void setTotalWorkAmount(long workTotal) {
                        monitor.beginTask("Update image file", (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)(workDone - this.prevDone));
                        this.prevDone = workDone;
                    }
                });
                ImageProvider.getInstance().syncMetaData();
                ImageLibrary.this.refreshImages();
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot update image";
            }
        }.start();
    }

    protected void uploadNewImage(final String name, final String category, final String fileName) {
        new ConsoleJob("Upload image file", (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                LibraryImage image = new LibraryImage();
                long fileSize = new File(fileName).length();
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(fileName);
                    byte[] imageData = new byte[(int)fileSize];
                    stream.read(imageData);
                    image.setBinaryData(imageData);
                    image.setName(name);
                    image.setCategory(category);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
                ImageLibrary.this.session.createImage(image, new ProgressListener(){
                    private long prevDone = 0L;

                    public void setTotalWorkAmount(long workTotal) {
                        monitor.beginTask("Upload image file", (int)workTotal);
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)(workDone - this.prevDone));
                        this.prevDone = workDone;
                    }
                });
                ImageProvider.getInstance().syncMetaData();
                ImageLibrary.this.refreshImages();
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot update image";
            }
        }.start();
    }

    protected void deleteImage() {
        GalleryItem[] selection;
        GalleryItem[] galleryItemArray = selection = this.gallery.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem item = galleryItemArray[n2];
            try {
                this.session.deleteImage((LibraryImage)item.getData());
                GalleryItem category = item.getParentItem();
                this.gallery.remove(item);
                if (category != null && category.getItemCount() == 0) {
                    this.gallery.remove(category);
                }
            }
            catch (NXCException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ImageLibrary.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.gallery);
        this.gallery.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        int selectionCount = this.gallery.getSelectionCount();
        if (selectionCount == 1) {
            manager.add((IAction)this.actionEdit);
        }
        if (selectionCount > 0) {
            GalleryItem[] items = this.gallery.getSelection();
            boolean protectedFound = false;
            GalleryItem[] galleryItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GalleryItem item = galleryItemArray[n2];
                if (((LibraryImage)item.getData()).isProtected()) {
                    protectedFound = true;
                    break;
                }
                ++n2;
            }
            if (!protectedFound) {
                manager.add((IAction)this.actionDelete);
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)this.actionNew);
        toolBarManager.add((IAction)this.actionRefresh);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionZoomIn);
        toolBarManager.add((IAction)this.actionZoomOut);
    }

    private void refreshImages() throws NetXMSClientException, IOException {
        new ConsoleJob("Reload image library", (IWorkbenchPart)this, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List imageLibrary = ImageLibrary.this.session.getImageLibrary();
                int i = 0;
                while (i < imageLibrary.size()) {
                    LibraryImage image = (LibraryImage)imageLibrary.get(i);
                    if (!image.isComplete()) {
                        try {
                            LibraryImage completeImage = ImageLibrary.this.session.getImage(image.getGuid());
                            imageLibrary.set(i, completeImage);
                        }
                        catch (Exception e) {
                            Activator.logError("Exception in ImageLibrary.refreshImages()", e);
                        }
                    }
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ImageLibrary.this.refreshUI(imageLibrary);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load image library";
            }
        }.start();
    }

    private void refreshUI(List<LibraryImage> imageLibrary) {
        HashMap categories = new HashMap();
        for (LibraryImage image : imageLibrary) {
            String category = image.getCategory();
            if (!categories.containsKey(category)) {
                categories.put(category, new ArrayList());
            }
            ((List)categories.get(category)).add(image);
        }
        this.knownCategories = categories.keySet();
        this.gallery.removeAll();
        for (String category : categories.keySet()) {
            GalleryItem categoryItem = new GalleryItem(this.gallery, 0);
            categoryItem.setText(category);
            List categoryImages = (List)categories.get(category);
            for (LibraryImage image : categoryImages) {
                GalleryItem imageItem = new GalleryItem(categoryItem, 0);
                imageItem.setText(image.getName());
                byte[] binaryData = image.getBinaryData();
                if (binaryData != null) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(binaryData);
                    try {
                        imageItem.setImage(new Image((Device)Display.getDefault(), (InputStream)stream));
                    }
                    catch (SWTException e) {
                        Activator.logError("Exception in ImageLibrary.refreshUI()", (Exception)((Object)e));
                        imageItem.setImage(ImageProvider.getInstance().getImage(null));
                    }
                } else {
                    imageItem.setImage(ImageProvider.getInstance().getImage(null));
                }
                imageItem.setData((Object)image);
            }
        }
        this.gallery.redraw();
    }

    @Override
    public void imageUpdated(UUID guid) {
        try {
            this.refreshImages();
        }
        catch (NetXMSClientException e) {
            Activator.logError("Exception in ImageLibrary.imageUpdated()", (Exception)((Object)e));
        }
        catch (IOException e) {
            Activator.logError("Exception in ImageLibrary.imageUpdated()", e);
        }
    }
}

