/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.widgets;

import java.util.UUID;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.base.NXCommon;
import org.netxms.ui.eclipse.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ImageSelector
extends AbstractSelector
implements ImageUpdateListener {
    private UUID imageGuid = NXCommon.EMPTY_GUID;

    public ImageSelector(Composite parent, int style) {
        super(parent, style, 0);
        ImageProvider.getInstance().addUpdateListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageProvider.getInstance().removeUpdateListener(ImageSelector.this);
            }
        });
    }

    protected void selectionButtonHandler() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            LibraryImage image = dlg.getLibraryImage();
            if (image != null) {
                this.setText(image.getName());
                this.setImage(dlg.getImage());
                this.imageGuid = dlg.getGuid();
            } else {
                this.setText("<default>");
                this.setImage(null);
                this.imageGuid = NXCommon.EMPTY_GUID;
            }
            this.getParent().layout();
        }
    }

    protected String getButtonToolTip() {
        return "Select image from image library";
    }

    public UUID getImageGuid() {
        return this.imageGuid;
    }

    public void setImageGuid(UUID imageGuid, boolean redoLayout) {
        this.imageGuid = imageGuid;
        if (imageGuid.equals(NXCommon.EMPTY_GUID)) {
            this.setText("<default>");
            this.setImage(null);
        } else {
            LibraryImage image = ImageProvider.getInstance().getLibraryImageObject(imageGuid);
            if (image != null) {
                this.setText(image.getName());
                this.setImage(ImageProvider.getInstance().getImage(imageGuid));
            } else {
                this.setText("<?>" + imageGuid.toString());
                this.setImage(null);
            }
        }
        if (redoLayout) {
            this.getParent().layout();
        }
    }

    @Override
    public void imageUpdated(UUID guid) {
        if (guid.equals(this.imageGuid)) {
            this.setImage(ImageProvider.getInstance().getImage(this.imageGuid));
            this.getParent().layout();
        }
    }
}

