/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.ui.eclipse.datacollection.dialogs.CreateSnmpDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.shared.MibCache;

public class CreateSnmpDci
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private List<SnmpValue> objects = new ArrayList<SnmpValue>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        CreateSnmpDciDialog dlg;
        String description;
        if (this.objects.size() == 0) {
            return;
        }
        MibObject mibObject = MibCache.findObject((String)this.objects.get(0).getName(), (boolean)false);
        String string = description = mibObject != null ? mibObject.getName() : this.objects.get(0).getName();
        if (this.objects.size() > 1) {
            description = String.valueOf(description) + " @@instance@@";
        }
        if ((dlg = new CreateSnmpDciDialog(this.shell, description)).open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final ArrayList<SnmpValue> values = new ArrayList<SnmpValue>(this.objects);
        HashSet<Node> nodes = new HashSet<Node>();
        for (SnmpValue v : values) {
            Node node = (Node)session.findObjectById(v.getNodeId(), Node.class);
            if (node == null) continue;
            nodes.add(node);
        }
        final HashMap<Long, Boolean> lockRequired = new HashMap<Long, Boolean>(nodes.size());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        for (Node n : nodes) {
            IViewReference ref = page.findViewReference("org.netxms.ui.eclipse.datacollection.view.data_collection_editor", Long.toString(n.getObjectId()));
            lockRequired.put(n.getObjectId(), ref == null || ref.getView(false) == null);
        }
        new ConsoleJob("Creating new SNMP DCI...", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Cannot create DCI";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask("Creating data collection items", values.size());
                for (SnmpValue v : values) {
                    String description = dlg.getDescription().replaceAll("@@instance@@", Long.toString(v.getObjectId().getIdFromPos(v.getObjectId().getLength() - 1)));
                    CreateSnmpDci.createDci(session, v, description, dlg.getPollingInterval(), dlg.getRetentionTime(), dlg.getDeltaCalculation(), lockRequired);
                    monitor.worked(1);
                }
                monitor.done();
            }
        }.start();
    }

    private static void createDci(NXCSession session, SnmpValue value, String description, int pollingInterval, int retentionTime, int deltaCalculation, Map<Long, Boolean> lockRequired) throws Exception {
        Node node = (Node)session.findObjectById(value.getNodeId(), Node.class);
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = lockRequired.get(node.getObjectId()) != false ? session.openDataCollectionConfiguration(node.getObjectId()) : new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = (DataCollectionItem)dcc.findItem(dcc.createItem(), DataCollectionItem.class);
        dci.setPollingInterval(pollingInterval);
        dci.setRetentionTime(retentionTime);
        dci.setOrigin(2);
        dci.setDataType(CreateSnmpDci.dciTypeFromAsnType(value.getType()));
        dci.setStatus(0);
        dci.setDescription(description);
        dci.setDeltaCalculation(deltaCalculation);
        dci.setName(value.getName());
        dcc.modifyObject((DataCollectionObject)dci);
        if (lockRequired.get(node.getObjectId()).booleanValue()) {
            dcc.close();
        }
    }

    private static int dciTypeFromAsnType(int type) {
        switch (type) {
            case 65: 
            case 66: 
            case 71: {
                return 1;
            }
            case 70: {
                return 3;
            }
            case 2: {
                return 0;
            }
        }
        return 4;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof SnmpValue)) continue;
                this.objects.add((SnmpValue)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

