/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectSelectionDialog
extends Dialog {
    private ObjectTree objectTree;
    private long[] rootObjects;
    private long[] selectedObjects;
    private Set<Integer> classFilter;
    private boolean multiSelection;

    public static Set<Integer> createNodeSelectionFilter(boolean allowMobileDevices) {
        HashSet<Integer> classFilter = new HashSet<Integer>(7);
        classFilter.add(4);
        classFilter.add(6);
        classFilter.add(1);
        classFilter.add(7);
        classFilter.add(5);
        classFilter.add(14);
        classFilter.add(2);
        if (allowMobileDevices) {
            classFilter.add(31);
        }
        return classFilter;
    }

    public static Set<Integer> createZoneSelectionFilter() {
        HashSet<Integer> classFilter = new HashSet<Integer>(7);
        classFilter.add(4);
        classFilter.add(6);
        return classFilter;
    }

    public static Set<Integer> createTemplateSelectionFilter() {
        HashSet<Integer> classFilter = new HashSet<Integer>(3);
        classFilter.add(10);
        classFilter.add(9);
        classFilter.add(8);
        return classFilter;
    }

    public static Set<Integer> createNodeAndTemplateSelectionFilter(boolean allowMobileDevices) {
        HashSet<Integer> classFilter = new HashSet<Integer>(9);
        classFilter.add(4);
        classFilter.add(1);
        classFilter.add(7);
        classFilter.add(5);
        classFilter.add(14);
        classFilter.add(2);
        classFilter.add(10);
        classFilter.add(9);
        classFilter.add(8);
        if (allowMobileDevices) {
            classFilter.add(31);
        }
        return classFilter;
    }

    public static Set<Integer> createContainerSelectionFilter() {
        HashSet<Integer> classFilter = new HashSet<Integer>(2);
        classFilter.add(7);
        classFilter.add(5);
        return classFilter;
    }

    public static Set<Integer> createBusinessServiceSelectionFilter() {
        HashSet<Integer> classFilter = new HashSet<Integer>(2);
        classFilter.add(27);
        classFilter.add(28);
        return classFilter;
    }

    public ObjectSelectionDialog(Shell parentShell, long[] rootObjects, Set<Integer> classFilter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.rootObjects = rootObjects;
        this.classFilter = classFilter;
        this.multiSelection = true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ObjectSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectObject.cx"), settings.getInt("SelectObject.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            newShell.setSize(400, 350);
        }
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        this.objectTree = new ObjectTree(dialogArea, 0, this.multiSelection ? 2 : 0, this.rootObjects, this.classFilter);
        String text = settings.get("SelectObject.Filter");
        if (text != null) {
            this.objectTree.setFilter(text);
        }
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.multiSelection) {
            Long[] objects = this.objectTree.getSelectedObjects();
            this.selectedObjects = new long[objects.length];
            int i = 0;
            while (i < objects.length) {
                this.selectedObjects[i] = objects[i];
                ++i;
            }
        } else {
            long objectId = this.objectTree.getFirstSelectedObject();
            if (objectId != 0L) {
                this.selectedObjects = new long[1];
                this.selectedObjects[0] = objectId;
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ObjectSelectionDialog_Warning, (String)Messages.ObjectSelectionDialog_WarningText);
                return;
            }
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectObject.cx", size.x);
        settings.put("SelectObject.cy", size.y);
        settings.put("SelectObject.Filter", this.objectTree.getFilter());
    }

    public List<GenericObject> getSelectedObjects() {
        if (this.selectedObjects == null) {
            return new ArrayList<GenericObject>(0);
        }
        return ((NXCSession)ConsoleSharedData.getSession()).findMultipleObjects(this.selectedObjects, false);
    }

    public GenericObject[] getSelectedObjects(Class<? extends GenericObject> classFilter) {
        if (this.selectedObjects == null) {
            return new GenericObject[0];
        }
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        HashSet<GenericObject> resultSet = new HashSet<GenericObject>(this.selectedObjects.length);
        int i = 0;
        while (i < this.selectedObjects.length) {
            GenericObject object = session.findObjectById(this.selectedObjects[i]);
            if (classFilter.isInstance(object)) {
                resultSet.add(object);
            }
            ++i;
        }
        return resultSet.toArray(new GenericObject[resultSet.size()]);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }
}

