/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.net.InetAddress;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.dialogs.IPAddressSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class IPAddressSelector
extends AbstractSelector {
    private Node node;
    private InetAddress address;
    private NXCSession session;

    public IPAddressSelector(Composite parent, int style) {
        super(parent, style, 4);
        this.setText(Messages.IPAddressSelector_None);
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    public void setNode(long nodeId) {
        GenericObject object = this.session.findObjectById(nodeId);
        if (object instanceof Node) {
            this.node = (Node)object;
            this.address = this.node.getPrimaryIP();
            this.setText(this.address.getHostAddress());
        } else {
            this.node = null;
            this.setText(Messages.IPAddressSelector_None);
        }
    }

    public void setNode(Node node) {
        this.node = node;
        this.address = node.getPrimaryIP();
        this.setText(this.address.getHostAddress());
    }

    protected void selectionButtonHandler() {
        IPAddressSelectionDialog dlg = new IPAddressSelectionDialog(this.getShell(), this.node);
        if (dlg.open() == 0) {
            this.address = dlg.getAddress();
            this.setText(this.address.getHostAddress());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

