/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.ContextListener;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;

public class DAGExpandCollapseManager
implements ExpandCollapseManager {
    private InternalLayoutContext context;
    private HashSet expandedNodes = new HashSet();
    private HashSet nodesToPrune = new HashSet();
    private HashSet nodesToUnprune = new HashSet();
    private HashSet nodesToUpdate = new HashSet();
    private boolean cleanLayoutScheduled = false;

    public void initExpansion(LayoutContext context2) {
        if (!(context2 instanceof InternalLayoutContext)) {
            throw new RuntimeException("This manager works only with org.eclipse.zest.core.widgets.InternalLayoutContext");
        }
        this.context = (InternalLayoutContext)context2;
        this.context.addGraphStructureListener(new GraphStructureListener(){

            public boolean nodeRemoved(LayoutContext context, NodeLayout node) {
                if (DAGExpandCollapseManager.this.isExpanded(node)) {
                    DAGExpandCollapseManager.this.collapse(node);
                }
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean nodeAdded(LayoutContext context, NodeLayout node) {
                DAGExpandCollapseManager.this.resetState(node);
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean connectionRemoved(LayoutContext context, ConnectionLayout connection) {
                NodeLayout target = connection.getTarget();
                if (!DAGExpandCollapseManager.this.isExpanded(target) && target.getIncomingConnections().length == 0) {
                    DAGExpandCollapseManager.this.expand(target);
                }
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean connectionAdded(LayoutContext context, ConnectionLayout connection) {
                DAGExpandCollapseManager.this.resetState(connection.getTarget());
                DAGExpandCollapseManager.this.updateNodeLabel(connection.getSource());
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }
        });
        this.context.addContextListener((ContextListener)new ContextListener.Stub(){

            public void backgroundEnableChanged(LayoutContext context) {
                DAGExpandCollapseManager.this.flushChanges(false, false);
            }
        });
    }

    public boolean canCollapse(LayoutContext context, NodeLayout node) {
        return this.isExpanded(node) && !node.isPruned() && node.getOutgoingConnections().length > 0;
    }

    public boolean canExpand(LayoutContext context, NodeLayout node) {
        return !this.isExpanded(node) && !node.isPruned() && node.getOutgoingConnections().length > 0;
    }

    private void collapseAllConnections(NodeLayout node) {
        ConnectionLayout[] outgoingConnections = node.getOutgoingConnections();
        int i = 0;
        while (i < outgoingConnections.length) {
            outgoingConnections[i].setVisible(false);
            ++i;
        }
        this.flushChanges(true, true);
    }

    private void expandAllConnections(NodeLayout node) {
        ConnectionLayout[] outgoingConnections = node.getOutgoingConnections();
        int i = 0;
        while (i < outgoingConnections.length) {
            outgoingConnections[i].setVisible(true);
            ++i;
        }
        this.flushChanges(true, true);
    }

    public void setExpanded(LayoutContext context, NodeLayout node, boolean expanded) {
        if (expanded) {
            if (this.canExpand(context, node)) {
                this.expand(node);
            }
            this.expandAllConnections(node);
        } else {
            if (this.canCollapse(context, node)) {
                this.collapse(node);
            }
            this.collapseAllConnections(node);
        }
        this.flushChanges(true, true);
    }

    private void expand(NodeLayout node) {
        this.setExpanded(node, true);
        NodeLayout[] successingNodes = node.getSuccessingNodes();
        int i = 0;
        while (i < successingNodes.length) {
            this.unpruneNode(successingNodes[i]);
            ++i;
        }
        this.updateNodeLabel(node);
    }

    private void collapse(NodeLayout node) {
        if (!this.isExpanded(node)) {
            return;
        }
        this.setExpanded(node, false);
        NodeLayout[] successors = node.getSuccessingNodes();
        int i = 0;
        while (i < successors.length) {
            this.checkPruning(successors[i]);
            if (this.isPruned(successors[i])) {
                this.collapse(successors[i]);
            }
            ++i;
        }
        this.updateNodeLabel(node);
    }

    private void checkPruning(NodeLayout node) {
        boolean prune = true;
        NodeLayout[] predecessors = node.getPredecessingNodes();
        int j = 0;
        while (j < predecessors.length) {
            if (this.isExpanded(predecessors[j])) {
                prune = false;
                break;
            }
            ++j;
        }
        if (prune) {
            this.pruneNode(node);
        } else {
            this.unpruneNode(node);
        }
    }

    private void resetState(NodeLayout node) {
        NodeLayout[] predecessors = node.getPredecessingNodes();
        if (predecessors.length == 0) {
            this.expand(node);
        } else {
            this.collapse(node);
            this.checkPruning(node);
        }
    }

    private void updateNodeLabel(NodeLayout node) {
        this.nodesToUpdate.add(node);
    }

    private void updateNodeLabel2(InternalNodeLayout node) {
        SubgraphFactory subgraphFactory = node.getOwnerLayoutContext().getSubgraphFactory();
        if (subgraphFactory instanceof DefaultSubgraph.PrunedSuccessorsSubgraphFactory) {
            ((DefaultSubgraph.PrunedSuccessorsSubgraphFactory)subgraphFactory).updateLabelForNode(node);
        }
    }

    private void pruneNode(NodeLayout node) {
        if (this.isPruned(node)) {
            return;
        }
        this.nodesToUnprune.remove(node);
        this.nodesToPrune.add(node);
    }

    private void unpruneNode(NodeLayout node) {
        if (!this.isPruned(node)) {
            return;
        }
        this.nodesToPrune.remove(node);
        this.nodesToUnprune.add(node);
    }

    private boolean isPruned(NodeLayout node) {
        if (this.nodesToUnprune.contains(node)) {
            return false;
        }
        if (this.nodesToPrune.contains(node)) {
            return true;
        }
        return node.isPruned();
    }

    private void flushChanges(boolean force, boolean clean) {
        NodeLayout node;
        boolean bl = this.cleanLayoutScheduled = this.cleanLayoutScheduled || clean;
        if (!force && !this.context.isBackgroundLayoutEnabled()) {
            return;
        }
        Iterator iterator = this.nodesToUnprune.iterator();
        while (iterator.hasNext()) {
            node = (NodeLayout)iterator.next();
            node.prune(null);
        }
        this.nodesToUnprune.clear();
        if (!this.nodesToPrune.isEmpty()) {
            this.context.createSubgraph(this.nodesToPrune.toArray(new NodeLayout[this.nodesToPrune.size()]));
            this.nodesToPrune.clear();
        }
        iterator = this.nodesToUpdate.iterator();
        while (iterator.hasNext()) {
            node = (InternalNodeLayout)iterator.next();
            this.updateNodeLabel2((InternalNodeLayout)node);
        }
        this.nodesToUpdate.clear();
        this.context.applyLayout(this.cleanLayoutScheduled);
        this.cleanLayoutScheduled = false;
        this.context.flushChanges(true);
    }

    private boolean isExpanded(NodeLayout node) {
        return this.expandedNodes.contains(node);
    }

    private void setExpanded(NodeLayout node, boolean expanded) {
        if (expanded) {
            this.expandedNodes.add(node);
        } else {
            this.expandedNodes.remove(node);
        }
    }
}

