/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.dialogs.CreateNetworkMapDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateNetworkMap
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final CreateNetworkMapDialog dlg = new CreateNetworkMapDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Create new network map", this.part, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCObjectCreationData cd = new NXCObjectCreationData(21, dlg.getName(), CreateNetworkMap.this.parentId);
                cd.setMapType(dlg.getType());
                cd.setSeedObjectId(dlg.getSeedObject());
                session.createObject(cd);
            }

            protected String getErrorMessage() {
                return "Cannot create network map object \"" + dlg.getName() + "\"";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof NetworkMapGroup || object instanceof NetworkMapRoot ? ((GenericObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }
}

