/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.servermanager.ServerManager;
import org.netxms.api.client.servermanager.ServerVariable;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariableComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariablesLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerConfigurationEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.view.server_config";
    public static final String JOB_FAMILY = "ServerConfigJob";
    private SortableTableViewer viewer;
    private ServerManager session;
    private Map<String, ServerVariable> varList;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;
    private RefreshAction actionRefresh;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_NEED_RESTART = 2;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Name", "Value", "Restart"};
        int[] widths = new int[]{200, 150, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerVariablesLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerVariableComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerConfigurationEditor.this.editVariable();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ServerConfigurationEditor.this.viewer.getSelection();
                ServerConfigurationEditor.this.actionEdit.setEnabled(selection.size() == 1);
                ServerConfigurationEditor.this.actionDelete.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ServerConfigurationEditor.this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.netxms.nxmc.serverconfig.viewer");
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = (ServerManager)ConsoleSharedData.getSession();
        this.refresh();
    }

    public void refresh() {
        new ConsoleJob("Load server configuration variables", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot load server configuration variables";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerConfigurationEditor.this.varList = ServerConfigurationEditor.this.session.getServerVariables();
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = ServerConfigurationEditor.this.varList;
                        synchronized (map) {
                            ServerConfigurationEditor.this.viewer.setInput((Object)ServerConfigurationEditor.this.varList.values().toArray());
                        }
                    }
                });
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ServerConfigurationEditor.this.refresh();
            }
        };
        this.actionAdd = new Action("&Create new...", SharedIcons.ADD_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.addVariable();
            }
        };
        this.actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                ServerConfigurationEditor.this.editVariable();
            }
        };
        this.actionEdit.setEnabled(false);
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.deleteVariables();
            }
        };
        this.actionDelete.setEnabled(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerConfigurationEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void addVariable() {
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), null, null);
        if (dlg.open() == 0) {
            new ConsoleJob("Create configuration variable", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot create configuration variable";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refresh();
                }
            }.start();
        }
    }

    private void editVariable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        ServerVariable var = (ServerVariable)selection.getFirstElement();
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), var.getName(), var.getValue());
        if (dlg.open() == 0) {
            new ConsoleJob("Modify configuration variable", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

                protected String getErrorMessage() {
                    return "Cannot modify configuration variable";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    ServerConfigurationEditor.this.refresh();
                }
            }.start();
        }
    }

    private void deleteVariables() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Confirmation", (String)"Are you sure you want to delete selected configuration variables?")) {
            return;
        }
        final ArrayList<String> names = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof ServerVariable)) continue;
            names.add(((ServerVariable)o).getName());
        }
        new ConsoleJob("Delete configuration variables", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String n : names) {
                    ServerConfigurationEditor.this.session.deleteServerVariable(n);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerConfigurationEditor.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete configuration variable";
            }
        }.start();
    }
}

