/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.zest.core.viewers.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.INestedContentProvider;
import org.eclipse.zest.core.viewers.internal.GraphItemStyler;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public abstract class AbstractStylingModelFactory
implements IStylingGraphModelFactory {
    private AbstractStructuredGraphViewer viewer;
    private int connectionStyle;
    private int nodeStyle;

    public AbstractStylingModelFactory(AbstractStructuredGraphViewer viewer) {
        this.viewer = viewer;
        this.connectionStyle = 0;
        this.nodeStyle = 0;
    }

    public void styleConnection(GraphConnection conn) {
        GraphNode source = conn.getSource();
        GraphNode dest = conn.getDestination();
        LinkedList rightList = this.getConnectionList(source, dest);
        LinkedList leftList = null;
        if (dest != source) {
            leftList = this.getConnectionList(dest, source);
        }
        int size = leftList != null ? leftList.size() + rightList.size() : rightList.size();
        this.adjustCurves(rightList, size);
        if (leftList != null) {
            this.adjustCurves(leftList, size);
        }
    }

    protected void adjustCurves(List connections, int size) {
        int i = 0;
        while (i < connections.size()) {
            GraphConnection conn = (GraphConnection)connections.get(i);
            int radius = 20;
            if (conn.getSource() == conn.getDestination()) {
                radius = 40;
            } else if (size < 2) {
                radius = 0;
            }
            conn.setCurveDepth((i + 1) * radius);
            ++i;
        }
    }

    private LinkedList getConnectionList(GraphNode source, GraphNode dest) {
        LinkedList<GraphConnection> list = new LinkedList<GraphConnection>();
        for (GraphConnection c : source.getSourceConnections()) {
            if (c.getDestination() != dest) continue;
            list.add(c);
        }
        return list;
    }

    public void styleItem(GraphItem item) {
        GraphItemStyler.styleItem(item, this.getLabelProvider());
        if (item instanceof GraphConnection) {
            this.styleConnection((GraphConnection)item);
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.viewer;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.viewer.getLabelProvider();
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return (IStructuredContentProvider)this.viewer.getContentProvider();
    }

    @Override
    public GraphConnection createConnection(Graph graph, Object element, Object source, Object dest) {
        if (source == null || dest == null) {
            return null;
        }
        GraphConnection oldConnection = this.viewer.getGraphModelConnection(element);
        GraphNode sn = this.viewer.getGraphModelNode(source);
        GraphNode dn = this.viewer.getGraphModelNode(dest);
        if (oldConnection != null) {
            if (sn != oldConnection.getSource() || dn != oldConnection.getDestination()) {
                this.viewer.removeGraphModelConnection(oldConnection);
            } else {
                this.styleItem((GraphItem)oldConnection);
                return oldConnection;
            }
        }
        if (sn == null) {
            sn = this.createNode(graph, source);
        }
        if (dn == null) {
            dn = this.createNode(graph, dest);
        }
        GraphConnection c = this.viewer.addGraphModelConnection(element, sn, dn);
        this.styleItem((GraphItem)c);
        return c;
    }

    public GraphNode createNode(Graph graph, Object element, IFigure figure) {
        boolean isContainer;
        GraphNode node = null;
        if (this.getContentProvider() instanceof INestedContentProvider && (isContainer = ((INestedContentProvider)this.getContentProvider()).hasChildren(element))) {
            node = this.viewer.addGraphModelContainer(element);
            this.styleItem((GraphItem)node);
            Object[] childNodes = ((INestedContentProvider)this.getContentProvider()).getChildren(element);
            childNodes = this.filter(this.getViewer().getInput(), childNodes);
            if (childNodes == null) {
                return node;
            }
            int i = 0;
            while (i < childNodes.length) {
                GraphNode childNode = this.viewer.addGraphModelNode((GraphContainer)node, childNodes[i]);
                this.styleItem((GraphItem)childNode);
                ++i;
            }
            ((GraphContainer)node).applyLayout();
            return node;
        }
        node = this.viewer.addGraphModelNode(element, figure);
        this.styleItem((GraphItem)node);
        return node;
    }

    @Override
    public GraphNode createNode(Graph graph, Object element) {
        IFigure nodeFigure = null;
        if (this.getLabelProvider() instanceof IFigureProvider) {
            nodeFigure = ((IFigureProvider)this.getLabelProvider()).getFigure(element);
        }
        return this.createNode(graph, element, nodeFigure);
    }

    @Override
    public void setConnectionStyle(int style) {
        this.connectionStyle = style;
    }

    @Override
    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    @Override
    public void setNodeStyle(int style) {
        this.nodeStyle = style;
    }

    @Override
    public int getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public void update(GraphItem item) {
        this.styleItem(item);
    }

    @Override
    public void update(GraphItem[] items) {
        int i = 0;
        while (i < items.length) {
            this.styleItem(items[i]);
            ++i;
        }
    }

    @Override
    public void refreshGraph(Graph graph) {
        HashMap oldMap = this.viewer.getNodesMap();
        HashMap nodesMap = new HashMap();
        for (Object key : oldMap.keySet()) {
            nodesMap.put(key, oldMap.get(key));
        }
        this.clearGraph(graph);
        this.doBuildGraph(graph);
        GraphNode[] nodes = this.getNodesArray(graph);
        if (nodes.length < nodesMap.keySet().size()) {
            int i = 0;
            while (i < nodes.length) {
                GraphNode oldNode = (GraphNode)nodesMap.get(nodes[i].getData());
                if (oldNode != null) {
                    nodes[i].setLocation((double)oldNode.getLocation().x, (double)oldNode.getLocation().y);
                    if (oldNode.isSizeFixed()) {
                        nodes[i].setSize((double)oldNode.getSize().width, (double)oldNode.getSize().height);
                    }
                }
                ++i;
            }
        } else {
            for (Object key : nodesMap.keySet()) {
                GraphNode node = this.viewer.getGraphModelNode(key);
                if (node == null) continue;
                GraphNode oldNode = (GraphNode)nodesMap.get(key);
                node.setLocation((double)oldNode.getLocation().x, (double)oldNode.getLocation().y);
                if (!oldNode.isSizeFixed()) continue;
                node.setSize((double)oldNode.getSize().width, (double)oldNode.getSize().height);
            }
        }
    }

    public void clearGraph(Graph graph) {
        graph.setSelection(null);
        Object[] nodeElements = this.viewer.getNodeElements();
        int i = 0;
        while (i < nodeElements.length) {
            this.viewer.removeGraphModelNode(nodeElements[i]);
            ++i;
        }
        Object[] connectionElements = this.viewer.getConnectionElements();
        int i2 = 0;
        while (i2 < connectionElements.length) {
            this.viewer.removeGraphModelConnection(connectionElements[i2]);
            ++i2;
        }
    }

    protected void doBuildGraph(Graph model) {
        this.clearGraph(model);
        model.setConnectionStyle(this.getConnectionStyle());
        model.setNodeStyle(this.getNodeStyle());
    }

    protected boolean filterElement(Object parent, Object element) {
        ViewerFilter[] filters = this.getViewer().getFilters();
        int i = 0;
        while (i < filters.length) {
            boolean selected = filters[i].select((Viewer)this.viewer, parent, element);
            if (!selected) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Object[] filter(Object parent, Object[] elements) {
        Object[] result = elements;
        ViewerFilter[] filters = this.getViewer().getFilters();
        int i = 0;
        while (i < filters.length) {
            result = filters[i].filter((Viewer)this.viewer, parent, result);
            ++i;
        }
        return result;
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    protected GraphNode[] getNodesArray(Graph graph) {
        GraphNode[] nodesArray = new GraphNode[graph.getNodes().size()];
        nodesArray = graph.getNodes().toArray(nodesArray);
        return nodesArray;
    }

    protected GraphConnection[] getConnectionArray(Graph graph) {
        GraphConnection[] connectionArray = new GraphConnection[graph.getConnections().size()];
        connectionArray = graph.getConnections().toArray(connectionArray);
        return connectionArray;
    }
}

