/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.EditClusterResourceDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.ResourceListComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.ResourceListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ClusterResources
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_IP_ADDRESS = 1;
    private Cluster object;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<ClusterResource> resources = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Cluster)this.getElement().getAdapter(Cluster.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"Name", "Virtual IP"};
        int[] columnWidths = new int[]{250, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ResourceListComparator());
        this.resources = new ArrayList<ClusterResource>(this.object.getResources().size());
        for (ClusterResource r : this.object.getResources()) {
            this.resources.add(new ClusterResource(r));
        }
        this.viewer.setInput((Object)this.resources.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterResources.this.addResource();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("&Modify...");
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterResources.this.editResource();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ClusterResources.this.deleteResource();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ClusterResources.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ClusterResources.this.viewer.getSelection();
                ClusterResources.this.editButton.setEnabled(selection.size() == 1);
                ClusterResources.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    private void addResource() {
        EditClusterResourceDialog dlg = new EditClusterResourceDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            ClusterResource r2;
            long id = 1L;
            for (ClusterResource r2 : this.resources) {
                if (r2.getId() < id) continue;
                id = r2.getId() + 1L;
            }
            r2 = new ClusterResource(id, dlg.getName(), dlg.getAddress());
            this.resources.add(r2);
            this.viewer.setInput((Object)this.resources.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)r2));
            this.isModified = true;
        }
    }

    private void editResource() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ClusterResource r = (ClusterResource)selection.getFirstElement();
        EditClusterResourceDialog dlg = new EditClusterResourceDialog(this.getShell(), r);
        if (dlg.open() == 0) {
            r.setName(dlg.getName());
            r.setVirtualAddress(dlg.getAddress());
            this.viewer.update((Object)r, null);
            this.isModified = true;
        }
    }

    private void deleteResource() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        for (Object o : selection.toList()) {
            this.resources.remove(o);
        }
        this.viewer.setInput((Object)this.resources.toArray());
        this.isModified = true;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setResourceList(this.resources);
        new ConsoleJob("Update cluster resource list", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                ClusterResources.this.isModified = false;
            }

            protected String getErrorMessage() {
                return "Cannot update cluster resource list";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ClusterResources.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

