/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] functions = new String[]{"last()", "average(", "deviation(", "diff()", "error(", "sum("};
    private NXCSession session;
    private Map<NodeItemPair, String> dciNameCache = new HashMap<NodeItemPair, String>();
    private List<ConditionDciInfo> elementList;

    public DciListLabelProvider(List<ConditionDciInfo> elementList) {
        this.elementList = elementList;
        this.session = (NXCSession)ConsoleSharedData.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ConditionDciInfo dci = (ConditionDciInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                GenericObject object = this.session.findObjectById(dci.getNodeId());
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.getNodeId()) + "]";
            }
            case 2: {
                String name = this.dciNameCache.get(new NodeItemPair(dci.getNodeId(), dci.getDciId()));
                return name != null ? name : "<unresolved>";
            }
            case 3: {
                int f = dci.getFunction();
                StringBuilder text = new StringBuilder(functions[f]);
                if (f != 3 && f != 0) {
                    text.append(dci.getPolls());
                    text.append(')');
                }
                return text.toString();
            }
        }
        return null;
    }

    public void resolveDciNames(final Collection<ConditionDciInfo> dciList) {
        new ConsoleJob("Resolve DCI names", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String[] names = DciListLabelProvider.this.session.resolveDciNames(dciList);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        for (ConditionDciInfo dci : dciList) {
                            DciListLabelProvider.this.dciNameCache.put(new NodeItemPair(dci.getNodeId(), dci.getDciId()), names[i++]);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot resolve DCI names";
            }
        }.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(new NodeItemPair(nodeId, dciId), name);
    }

    private class NodeItemPair {
        long nodeId;
        long dciId;

        public NodeItemPair(long nodeId, long dciId) {
            this.nodeId = nodeId;
            this.dciId = dciId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.dciId ^ this.dciId >>> 32);
            result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeItemPair other = (NodeItemPair)obj;
            if (this.dciId != other.dciId) {
                return false;
            }
            return this.nodeId == other.nodeId;
        }
    }
}

