/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.shared;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class ImageProvider {
    private static ImageProvider instance = null;
    private static final Map<UUID, Image> cache = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, LibraryImage> libraryIndex = Collections.synchronizedMap(new HashMap());
    private final Image missingImage;
    private final Set<ImageUpdateListener> updateListeners;
    private NXCSession session;
    private Display display;

    public static void createInstance(Display display, NXCSession session) {
        if (instance == null) {
            instance = new ImageProvider(display, session);
        }
    }

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageProvider(Display display, NXCSession session) {
        this.display = display;
        this.session = session;
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.netxms.ui.eclipse.imagelibrary", (String)"icons/missing.png");
        this.missingImage = imageDescriptor.createImage((Device)display);
        this.updateListeners = new HashSet<ImageUpdateListener>();
    }

    public void addUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void syncMetaData() throws NXCException, IOException {
        List imageLibrary = this.session.getImageLibrary();
        libraryIndex.clear();
        this.clearCache();
        for (LibraryImage libraryImage : imageLibrary) {
            libraryIndex.put(libraryImage.getGuid(), libraryImage);
        }
    }

    private void clearCache() {
        for (Image image : cache.values()) {
            if (image == this.missingImage) continue;
            image.dispose();
        }
        cache.clear();
    }

    public Image getImage(final UUID guid) {
        Image image;
        if (cache.containsKey(guid)) {
            image = cache.get(guid);
        } else {
            image = this.missingImage;
            cache.put(guid, image);
            if (libraryIndex.containsKey(guid)) {
                new ConsoleJob("Load Image", null, "org.netxms.ui.eclipse.imagelibrary", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        ImageProvider.this.loadImageFromServer(guid);
                    }

                    protected String getErrorMessage() {
                        return null;
                    }
                }.start();
            }
        }
        return image;
    }

    private void loadImageFromServer(UUID guid) {
        try {
            LibraryImage libraryImage = this.session.getImage(guid);
            ByteArrayInputStream stream = new ByteArrayInputStream(libraryImage.getBinaryData());
            try {
                cache.put(guid, new Image((Device)this.display, (InputStream)stream));
                this.notifySubscribers(guid);
            }
            catch (SWTException e) {
                Activator.logError("Cannot decode image", (Exception)((Object)e));
                cache.put(guid, this.missingImage);
            }
        }
        catch (Exception e) {
            Activator.logError("Cannot retrive image from server", e);
        }
    }

    private void notifySubscribers(UUID guid) {
        for (ImageUpdateListener listener : this.updateListeners) {
            listener.imageUpdated(guid);
        }
    }

    public LibraryImage getLibraryImageObject(UUID guid) {
        return libraryIndex.get(guid);
    }

    public List<LibraryImage> getImageLibrary() {
        return new ArrayList<LibraryImage>(libraryIndex.values());
    }

    public void invalidateImage(UUID guid, boolean removed) {
        Image image = cache.get(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        cache.remove(guid);
        if (removed) {
            libraryIndex.remove(guid);
        }
        this.notifySubscribers(guid);
    }
}

