/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class EditPaneWidget
extends Canvas
implements PaintListener {
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 127);
    private DashboardControl dbc;
    private DashboardElement element;
    private Action actionEdit;
    private Action actionEditXml;
    private Action actionDelete;

    public EditPaneWidget(Composite parent, DashboardControl dbc, DashboardElement element) {
        super(parent, 0x40000000);
        this.dbc = dbc;
        this.element = element;
        this.addPaintListener(this);
        this.createActions();
        this.createPopupMenu();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.getSize();
        gc.setBackground(BACKGROUND_COLOR);
        gc.setAlpha(20);
        gc.fillRectangle(0, 0, size.x, size.y);
    }

    private void createActions() {
        this.actionEdit = new Action(Messages.EditPaneWidget_Edit){

            public void run() {
                EditPaneWidget.this.dbc.editElement(EditPaneWidget.this.element);
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditXml = new Action(Messages.EditPaneWidget_EditXML){

            public void run() {
                EditPaneWidget.this.dbc.editElementXml(EditPaneWidget.this.element);
            }
        };
        this.actionEditXml.setImageDescriptor(SharedIcons.XML);
        this.actionDelete = new Action(Messages.EditPaneWidget_Delete){

            public void run() {
                EditPaneWidget.this.dbc.deleteElement(EditPaneWidget.this.element);
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditPaneWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionEditXml);
        mgr.add((IAction)this.actionDelete);
    }
}

