/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;

@Root(name="parameter", strict=false)
public class ReportParameter {
    public static final int INTEGER = 0;
    public static final int STRING = 1;
    public static final int OBJECT_ID = 2;
    public static final int USER_ID = 3;
    public static final int OBJECT_LIST = 4;
    public static final int TIMESTAMP = 5;
    public static final int START_DATE = 6;
    public static final int END_DATE = 7;
    private static final Map<String, Integer> TYPE_MAP = new HashMap<String, Integer>();
    @Attribute
    private String name;
    @Attribute
    private String javaClass;
    @Element(name="parameterDescription", required=false)
    private String description;
    @Element(name="defaultValueExpression", required=false)
    private String defaultValue;
    @ElementMap(entry="property", key="name", value="value", inline=true, attribute=true)
    private Map<String, String> properties;

    static {
        TYPE_MAP.put("java.lang.Integer", 0);
        TYPE_MAP.put("java.lang.String", 1);
        TYPE_MAP.put("java.util.Date", 5);
        TYPE_MAP.put("timestamp", 5);
        TYPE_MAP.put("startDate", 6);
        TYPE_MAP.put("endDate", 7);
        TYPE_MAP.put("object", 2);
        TYPE_MAP.put("objectList", 4);
        TYPE_MAP.put("user", 3);
    }

    public String getDisplayName() {
        String value = this.properties.get("netxms.displayName");
        return value != null ? value : this.description;
    }

    public int getDataType() {
        String nxtype = this.properties.get("netxms.type");
        Integer code = TYPE_MAP.get(nxtype != null ? nxtype : this.javaClass);
        return code != null ? code : 1;
    }

    public int getColumnSpan() {
        String value = this.properties.get("netxms.layout.columnSpan");
        return value != null ? Integer.parseInt(value) : 1;
    }

    public String getDescription() {
        return this.description != null ? this.description : this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }
}

