/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.views.helpers;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.ServerAction;
import org.netxms.ui.eclipse.actionmanager.Messages;

public class ActionLabelProvider
implements ITableLabelProvider {
    private static final String[] ACTION_TYPE = new String[]{Messages.ActionLabelProvider_ActionTypeExecute, Messages.ActionLabelProvider_ActionTypeRemoteExec, Messages.ActionLabelProvider_ActionTypeMail, Messages.ActionLabelProvider_ActionTypeSMS, Messages.ActionLabelProvider_ActionTypeForward};
    private ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.workbenchLabelProvider.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ServerAction action = (ServerAction)element;
        switch (columnIndex) {
            case 0: {
                return action.getName();
            }
            case 1: {
                try {
                    return ACTION_TYPE[action.getType()];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return Messages.ActionLabelProvider_Unknown;
                }
            }
            case 2: {
                return action.getRecipientAddress();
            }
            case 3: {
                return action.getEmailSubject();
            }
            case 4: {
                return action.getData();
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

