/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapResource;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.networkmaps.widgets.NetworkMapWidget;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ClusterResourceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ClusterResourceListLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ClusterTab
extends ObjectTab {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VIP = 1;
    public static final int COLUMN_OWNER = 2;
    private NetworkMapWidget clusterMap;
    private SortableTableViewer resourceList;
    private Cluster cluster;

    @Override
    protected void createTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.clusterMap = new NetworkMapWidget(content, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.clusterMap.setLayoutData((Object)gd);
        this.clusterMap.setMapLayout(3);
        String[] names = new String[]{"Resource", "VIP", "Owner"};
        int[] widths = new int[]{200, 120, 150};
        this.resourceList = new SortableTableViewer(content, names, widths, 0, 128, -1);
        this.resourceList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resourceList.setLabelProvider((IBaseLabelProvider)new ClusterResourceListLabelProvider());
        this.resourceList.setComparator((ViewerComparator)new ClusterResourceListComparator());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        this.resourceList.getControl().setLayoutData((Object)gd);
    }

    @Override
    public void objectChanged(GenericObject object) {
        if (object instanceof Cluster) {
            this.cluster = (Cluster)object;
            this.resourceList.setInput((Object)this.cluster.getResources().toArray());
            this.clusterMap.setContent(this.buildClusterMap());
        } else {
            this.cluster = null;
            this.resourceList.setInput((Object)new ClusterResource[0]);
            this.clusterMap.setContent(new NetworkMapPage());
        }
        this.getClientArea().layout(true);
    }

    @Override
    public boolean showForObject(GenericObject object) {
        return object instanceof Cluster;
    }

    private NetworkMapPage buildClusterMap() {
        NetworkMapPage page = new NetworkMapPage();
        long id = 1L;
        page.addElement((NetworkMapElement)new NetworkMapObject(id++, this.cluster.getObjectId()));
        for (GenericObject o : this.cluster.getAllChilds(2)) {
            page.addElement((NetworkMapElement)new NetworkMapObject(id, o.getObjectId()));
            page.addLink(new NetworkMapLink(0, 1L, id));
            this.addOwnedResources(page, id, o.getObjectId(), this.cluster.getResources());
            ++id;
        }
        return page;
    }

    private void addOwnedResources(NetworkMapPage page, long rootElementId, long objectId, List<ClusterResource> resources) {
        long elementId = rootElementId * 100000L;
        for (ClusterResource r : resources) {
            if (r.getCurrentOwner() != objectId) continue;
            page.addElement((NetworkMapElement)new NetworkMapResource(elementId, 1, (Object)r));
            page.addLink(new NetworkMapLink(0, rootElementId, elementId));
            ++elementId;
        }
    }
}

