/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.AvailabilityChart;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Capabilities;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Commands;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Comments;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Connection;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.GeneralInfo;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedColors;

public class ObjectOverview
extends ObjectTab {
    private NXCListener sessionListener = null;
    private Set<OverviewPageElement> elements = new HashSet<OverviewPageElement>();
    private ScrolledComposite scroller;
    private Composite viewArea;
    private Composite leftColumn;
    private Composite rightColumn;

    @Override
    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ObjectOverview.this.scroller.getClientArea();
                ObjectOverview.this.scroller.setMinSize(ObjectOverview.this.viewArea.computeSize(r.width, -1));
                ObjectOverview.this.objectChanged(ObjectOverview.this.getObject());
            }
        });
        this.viewArea = new Composite((Composite)this.scroller, 0);
        this.viewArea.setBackground(SharedColors.WHITE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.viewArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.viewArea);
        this.leftColumn = new Composite(this.viewArea, 0);
        this.leftColumn.setLayout(this.createColumnLayout());
        this.leftColumn.setBackground(SharedColors.WHITE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftColumn.setLayoutData((Object)gd);
        this.rightColumn = new Composite(this.viewArea, 0);
        this.rightColumn.setLayout(this.createColumnLayout());
        this.rightColumn.setBackground(SharedColors.WHITE);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = -1;
        this.rightColumn.setLayoutData((Object)gd);
        this.addElement(new GeneralInfo(this.leftColumn, this.getObject()));
        this.addElement(new Commands(this.leftColumn, this.getObject()));
        this.addElement(new AvailabilityChart(this.leftColumn, this.getObject()));
        this.addElement(new Comments(this.leftColumn, this.getObject()));
        this.addElement(new Capabilities(this.rightColumn, this.getObject()));
        this.addElement(new Connection(this.rightColumn, this.getObject()));
        this.sessionListener = new NXCListener(){

            public void notificationHandler(SessionNotification n) {
                GenericObject object;
                if (n.getCode() == 4 && (object = (GenericObject)n.getObject()) != null && ObjectOverview.this.getObject() != null && object.getObjectId() == ObjectOverview.this.getObject().getObjectId()) {
                    ObjectOverview.this.getViewPart().getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ObjectOverview.this.changeObject(object);
                        }
                    });
                }
            }
        };
        ConsoleSharedData.getSession().addListener((SessionListener)this.sessionListener);
    }

    private Layout createColumnLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        return layout;
    }

    private void addElement(OverviewPageElement element) {
        GridData gd = new GridData();
        gd.exclude = false;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        element.setLayoutData(gd);
        this.elements.add(element);
    }

    @Override
    public void objectChanged(GenericObject object) {
        this.viewArea.setRedraw(false);
        for (OverviewPageElement element : this.elements) {
            if (element.isApplicableForObject(object)) {
                element.setVisible(true);
                element.setObject(object);
            } else {
                element.setVisible(false);
            }
            boolean bl = ((GridData)element.getLayoutData()).exclude = !element.isVisible();
        }
        this.viewArea.layout(true, true);
        this.viewArea.setRedraw(true);
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.viewArea.computeSize(r.width, -1));
        Point s = this.viewArea.getSize();
        this.viewArea.redraw(0, 0, s.x, s.y, true);
    }

    @Override
    public void dispose() {
        if (this.sessionListener != null) {
            ConsoleSharedData.getSession().removeListener((SessionListener)this.sessionListener);
        }
        super.dispose();
    }

    @Override
    public void selected() {
        super.selected();
        this.objectChanged(this.getObject());
    }

    @Override
    public void refresh() {
        this.objectChanged(this.getObject());
    }
}

