/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import java.text.NumberFormat;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.NodeLink;
import org.netxms.client.objects.ServiceCheck;
import org.netxms.client.objects.ServiceContainer;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.tools.RegionalSettings;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeneralInfo
extends TableElement {
    public GeneralInfo(Composite parent, GenericObject object) {
        super(parent, object);
    }

    @Override
    protected void fillTable() {
        GenericObject object = this.getObject();
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.addPair("ID", Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            this.addPair("GUID", object.getGuid().toString());
        }
        this.addPair("Class", object.getObjectClassName());
        this.addPair("Status", StatusDisplayInfo.getStatusText((int)object.getStatus()));
        switch (object.getObjectClass()) {
            case 3: {
                Interface iface = (Interface)object;
                this.addPair("Interface Index", Integer.toString(iface.getIfIndex()));
                this.addPair("Interface Type", Integer.toString(iface.getIfType()));
                this.addPair("Description", iface.getDescription());
                this.addPair("Administrative State", iface.getAdminStateAsText());
                this.addPair("Operational State", iface.getOperStateAsText());
                this.addPair("MAC Address", iface.getMacAddress().toString());
                if ((iface.getFlags() & 2) != 0) {
                    this.addPair("Slot/Port", String.valueOf(Integer.toString(iface.getSlot())) + "/" + Integer.toString(iface.getPort()));
                    Node node = iface.getParentNode();
                    if (node != null && node.is8021xSupported()) {
                        this.addPair("802.1x PAE State", iface.getDot1xPaeStateAsText());
                        this.addPair("802.1x Backend State", iface.getDot1xBackendStateAsText());
                    }
                }
                if (iface.getPrimaryIP().isAnyLocalAddress()) break;
                if (session.isZoningEnabled()) {
                    this.addPair("Zone ID", Long.toString(iface.getZoneId()));
                }
                this.addPair("IP Address", iface.getPrimaryIP().getHostAddress());
                this.addPair("IP Subnet Mask", iface.getSubnetMask().getHostAddress());
                break;
            }
            case 2: {
                Node node = (Node)object;
                if (session.isZoningEnabled()) {
                    this.addPair("Zone ID", Long.toString(node.getZoneId()));
                }
                this.addPair("Primary Host Name", node.getPrimaryName());
                this.addPair("Primary IP Address", node.getPrimaryIP().getHostAddress());
                if (node.hasAgent()) {
                    this.addPair("NetXMS Agent Version", node.getAgentVersion());
                }
                this.addPair("System Description", node.getSystemDescription(), false);
                this.addPair("Platform Name", node.getPlatformName(), false);
                this.addPair("SNMP sysName", node.getSnmpSysName(), false);
                this.addPair("SNMP Object ID", node.getSnmpOID(), false);
                if ((node.getFlags() & 4) != 0) {
                    this.addPair("Bridge Base Address", node.getBridgeBaseAddress().toString());
                }
                this.addPair("Driver", node.getDriverName(), false);
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    this.addPair("Last Report", "never");
                } else {
                    this.addPair("Last Report", RegionalSettings.getDateTimeFormat().format(md.getLastReportTime()));
                }
                this.addPair("Device ID", md.getDeviceId());
                this.addPair("Vendor", md.getVendor());
                this.addPair("Model", md.getModel());
                this.addPair("Serial Number", md.getSerialNumber());
                this.addPair("Operating System", md.getOsName());
                this.addPair("OS Version", md.getOsVersion());
                this.addPair("User", md.getUserId(), false);
                if (md.getBatteryLevel() < 0) break;
                this.addPair("Battery Level", String.valueOf(Integer.toString(md.getBatteryLevel())) + "%");
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (!session.isZoningEnabled()) break;
                this.addPair("Zone ID", Long.toString(subnet.getZoneId()));
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                this.addPair("Zone ID", Long.toString(zone.getZoneId()));
                break;
            }
            case 29: {
                Node linkedNode = (Node)session.findObjectById(((NodeLink)object).getNodeId(), Node.class);
                if (linkedNode != null) {
                    this.addPair("Linked node", linkedNode.getObjectName());
                }
            }
            case 27: 
            case 28: {
                ServiceContainer service = (ServiceContainer)object;
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMinimumFractionDigits(3);
                nf.setMaximumFractionDigits(3);
                this.addPair("Uptime for day", String.valueOf(nf.format(service.getUptimeForDay())) + "%");
                this.addPair("Uptime for week", String.valueOf(nf.format(service.getUptimeForWeek())) + "%");
                this.addPair("Uptime for month", String.valueOf(nf.format(service.getUptimeForMonth())) + "%");
                break;
            }
            case 30: {
                ServiceCheck tmpl;
                ServiceCheck check = (ServiceCheck)object;
                this.addPair("Is template", check.isTemplate() ? "Yes" : "No");
                if (check.getTemplateId() == 0L || (tmpl = (ServiceCheck)session.findObjectById(check.getTemplateId(), ServiceCheck.class)) == null) break;
                this.addPair("Template", tmpl.getObjectName());
                break;
            }
        }
        if (object.getGeolocation().getType() != 0) {
            this.addPair("Location", object.getGeolocation().toString());
        }
    }

    @Override
    protected String getTitle() {
        return "General";
    }
}

