/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.jobs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.ui.eclipse.library.Messages;

public abstract class ConsoleJob
extends Job {
    private IWorkbenchSiteProgressService siteService;
    private String pluginId;
    private Object jobFamily;
    private boolean passException = false;
    private boolean printException = true;

    public ConsoleJob(String name, IWorkbenchPart wbPart, String pluginId, Object jobFamily) {
        super(name);
        this.pluginId = pluginId != null ? pluginId : "org.netxms.ui.eclipse.library";
        this.jobFamily = jobFamily;
        try {
            IWorkbenchPart part = wbPart != null ? wbPart : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            this.siteService = part != null ? (IWorkbenchSiteProgressService)wbPart.getSite().getService(IWorkbenchSiteProgressService.class) : null;
        }
        catch (NullPointerException nullPointerException) {
            this.siteService = null;
        }
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        try {
            try {
                this.runInternal(monitor);
                status = Status.OK_STATUS;
            }
            catch (Exception e) {
                if (this.printException) {
                    e.printStackTrace();
                }
                this.jobFailureHandler();
                status = this.createFailureStatus(e);
                this.jobFinalize();
            }
        }
        finally {
            this.jobFinalize();
        }
        return status;
    }

    public boolean belongsTo(Object family) {
        return family == this.jobFamily;
    }

    public void start() {
        if (this.siteService != null) {
            this.siteService.schedule((Job)this, 0L, true);
        } else {
            this.schedule();
        }
    }

    protected abstract void runInternal(IProgressMonitor var1) throws Exception;

    protected abstract String getErrorMessage();

    protected IStatus createFailureStatus(Exception e) {
        return new Status(4, this.pluginId, e instanceof NetXMSClientException ? ((NetXMSClientException)e).getErrorCode() : 0, String.valueOf(this.getErrorMessage()) + ": " + e.getMessage(), (Throwable)(this.passException ? e : null));
    }

    protected void jobFailureHandler() {
    }

    protected void jobFinalize() {
    }

    public boolean runInForeground() {
        this.passException = true;
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        boolean success = true;
        try {
            service.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IStatus status = ConsoleJob.this.run(monitor);
                    if (!status.isOK()) {
                        throw new InvocationTargetException(status.getException());
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            MessageDialog.openError(null, (String)Messages.ConsoleJob_ErrorDialogTitle, (String)(String.valueOf(this.getErrorMessage()) + ": " + cause.getLocalizedMessage()));
        }
        catch (InterruptedException interruptedException) {}
        return success;
    }

    protected void runInUIThread(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    protected Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public boolean isPrintException() {
        return this.printException;
    }

    public void setPrintException(boolean printException) {
        this.printException = printException;
    }
}

