/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.tools;

import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class IPAddressValidator
implements TextFieldValidator {
    private static final String IP_ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private boolean allowEmpty;

    public IPAddressValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        return text.matches(IP_ADDRESS_PATTERN);
    }

    public String getErrorMessage(String text, String label) {
        return String.valueOf(Messages.getString("IPAddressValidator.ErrorPrefix")) + label + Messages.getString("IPAddressValidator.ErrorSuffix");
    }
}

