/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.api;

import org.netxms.client.datacollection.DciValue;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dci")
public class ChartDciConfig {
    public static final String UNSET_COLOR = "UNSET";
    @Attribute
    public long nodeId;
    @Attribute
    public long dciId;
    @Element(required=false)
    public String color;
    @Element(required=false)
    public String name;
    @Element(required=false)
    public int lineWidth;
    @Element(required=false)
    public boolean area;
    @Element(required=false)
    public boolean showThresholds;

    public ChartDciConfig() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.color = UNSET_COLOR;
        this.name = "";
        this.lineWidth = 2;
        this.area = false;
    }

    public ChartDciConfig(ChartDciConfig src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.color = src.color;
        this.name = src.name;
        this.lineWidth = src.lineWidth;
        this.area = src.area;
    }

    public ChartDciConfig(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.name = dci.getDescription();
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.area = false;
    }

    public int getColorAsInt() {
        if (this.color.equals(UNSET_COLOR)) {
            return -1;
        }
        if (this.color.startsWith("0x")) {
            return Integer.parseInt(this.color.substring(2), 16);
        }
        return Integer.parseInt(this.color, 10);
    }

    public void setColor(int value) {
        this.color = "0x" + Integer.toHexString(value);
    }

    public String getName() {
        return this.name != null && !this.name.isEmpty() ? this.name : "[" + Long.toString(this.dciId) + "]";
    }
}

