/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class DirectedGraphLayoutAlgorithm
implements LayoutAlgorithm {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private int orientation = 2;
    private LayoutContext context;

    public DirectedGraphLayoutAlgorithm() {
    }

    public DirectedGraphLayoutAlgorithm(int orientation) {
        if (orientation == 2) {
            this.orientation = orientation;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation == 1 || orientation == 2) {
            this.orientation = orientation;
        }
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        HashMap<EntityLayout, Node> mapping = new HashMap<EntityLayout, Node>();
        DirectedGraph graph = new DirectedGraph();
        EntityLayout[] entities = this.context.getEntities();
        int i = 0;
        while (i < entities.length) {
            Node node = new Node((Object)entities[i]);
            node.setSize(new Dimension(10, 10));
            mapping.put(entities[i], node);
            graph.nodes.add((Object)node);
            ++i;
        }
        ConnectionLayout[] connections = this.context.getConnections();
        int i2 = 0;
        while (i2 < connections.length) {
            Node source = (Node)mapping.get(this.getEntity(connections[i2].getSource()));
            Node dest = (Node)mapping.get(this.getEntity(connections[i2].getTarget()));
            if (source != null && dest != null) {
                Edge edge = new Edge((Object)connections[i2], source, dest);
                graph.edges.add((Object)edge);
            }
            ++i2;
        }
        ExtendedDirectedGraphLayout directedGraphLayout = new ExtendedDirectedGraphLayout();
        directedGraphLayout.visit(graph);
        for (Node node : graph.nodes) {
            EntityLayout entity = (EntityLayout)node.data;
            if (this.orientation == 2) {
                entity.setLocation(node.x, node.y);
                continue;
            }
            entity.setLocation(node.y, node.x);
        }
    }

    private EntityLayout getEntity(NodeLayout node) {
        if (!node.isPruned()) {
            return node;
        }
        SubgraphLayout subgraph = node.getSubgraph();
        if (subgraph.isGraphEntity()) {
            return subgraph;
        }
        return null;
    }

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    class ExtendedDirectedGraphLayout
    extends DirectedGraphLayout {
        ExtendedDirectedGraphLayout() {
        }

        public void visit(DirectedGraph graph) {
            try {
                Field field = DirectedGraphLayout.class.getDeclaredField("steps");
                field.setAccessible(true);
                Object object = field.get((Object)this);
                List cfr_ignored_0 = (List)object;
                field.setAccessible(false);
                super.visit(graph);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

