/*
 * Decompiled with CFR 0.152.
 */
package org.netxms;

import java.io.Console;
import java.io.IOException;
import java.util.Properties;
import org.netxms.api.client.NetXMSClientException;
import org.netxms.client.NXCSession;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.util.InteractiveConsole;
import org.python.util.JLineConsole;

public class Shell {
    public static final String DEFAULT_SERVER = "127.0.0.1";
    public static final String DEFAULT_LOGIN = "admin";
    public static final String DEFAULT_PASSWORD = "netxms";
    private String server;
    private String login;
    private String password;

    public static void main(String[] args) {
        Shell shell = new Shell();
        try {
            shell.run(args);
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void run(String[] args) throws IOException, NetXMSClientException {
        this.readCredentials(args.length == 0 && this.isInteractive());
        NXCSession session = this.connect();
        InteractiveConsole console = this.createInterpreter(args);
        console.set("session", session);
        console.set("s", session);
        if (args.length == 0) {
            console.interact(this.getBanner(), null);
        } else {
            console.execfile(args[0]);
        }
        console.cleanup();
        session.disconnect();
    }

    private void readCredentials(boolean interactive) {
        this.server = System.getProperty("netxms.server");
        this.login = System.getProperty("netxms.login");
        this.password = System.getProperty("netxms.password");
        if (interactive) {
            Console console = System.console();
            if (this.server == null) {
                this.server = console.readLine("Server IP [127.0.0.1]: ", new Object[0]);
            }
            if (this.login == null) {
                this.login = console.readLine("Login [admin]: ", new Object[0]);
            }
            if (this.password == null) {
                char[] passwordChars = console.readPassword("Password [netxms]: ", new Object[0]);
                this.password = passwordChars == null || passwordChars.length == 0 ? DEFAULT_PASSWORD : new String(passwordChars);
            }
        }
        if (this.server == null || this.server.length() == 0) {
            this.server = DEFAULT_SERVER;
        }
        if (this.login == null || this.login.length() == 0) {
            this.login = DEFAULT_LOGIN;
        }
        if (this.password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    private String getBanner() {
        return "NetXMS 1.2.5 Interactive Shell";
    }

    private NXCSession connect() throws IOException, NetXMSClientException {
        NXCSession session = new NXCSession(this.server, this.login, this.password);
        session.connect();
        session.syncObjects();
        session.syncUserDatabase();
        return session;
    }

    protected boolean isInteractive() {
        PySystemState systemState = Py.getSystemState();
        boolean interactive = ((PyFile)Py.defaultSystemState.stdin).isatty();
        if (!interactive) {
            systemState.ps1 = systemState.ps2 = Py.EmptyString;
        }
        return interactive;
    }

    private InteractiveConsole createInterpreter(String[] args) {
        Properties postProperties = new Properties();
        String tempDirectory = System.getProperty("java.io.tmpdir") + "nxshell";
        postProperties.setProperty("python.cachedir", tempDirectory);
        postProperties.setProperty("python.cachedir.skip", "false");
        PySystemState.initialize(PySystemState.getBaseProperties(), postProperties, args);
        InteractiveConsole console = this.isInteractive() ? new JLineConsole() : new InteractiveConsole();
        Py.getSystemState().__setattr__("_jy_interpreter", Py.java2py(console));
        imp.load("site");
        console.exec("from org.netxms.client import *");
        console.exec("from org.netxms.api.client import *");
        return console;
    }
}

