/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client;

import java.util.Locale;

public abstract class NetXMSClientException
extends Exception {
    private static final long serialVersionUID = 1453981595988661913L;
    protected int errorCode;
    protected String additionalInfo;

    public NetXMSClientException(int errorCode) {
        this.errorCode = errorCode;
        this.additionalInfo = null;
    }

    public NetXMSClientException(int errorCode, String additionalInfo) {
        this.errorCode = errorCode;
        this.additionalInfo = additionalInfo;
    }

    protected abstract String getErrorMessage(int var1, String var2);

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        String msg = this.getErrorMessage(this.errorCode, "en");
        if (this.additionalInfo != null) {
            msg = String.valueOf(msg) + " (" + this.additionalInfo + ")";
        }
        return msg;
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale = Locale.getDefault();
        String msg = this.getErrorMessage(this.errorCode, locale.getLanguage());
        if (this.additionalInfo != null) {
            msg = String.valueOf(msg) + " (" + this.additionalInfo + ")";
        }
        return msg;
    }
}

