/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectId;

public class ColumnDefinition {
    private String name;
    private int dataType;
    private SnmpObjectId snmpObjectId;
    private String transformationScript;

    public ColumnDefinition(String name) {
        this.name = name;
        this.dataType = 4;
        this.snmpObjectId = null;
        this.transformationScript = null;
    }

    public ColumnDefinition(ColumnDefinition src) {
        this.name = src.name;
        this.dataType = src.dataType;
        this.snmpObjectId = src.snmpObjectId;
        this.transformationScript = src.transformationScript;
    }

    protected ColumnDefinition(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId);
        this.dataType = msg.getVariableAsInteger(baseId + 1L);
        this.transformationScript = msg.getVariableAsString(baseId + 2L);
        long[] oid = msg.getVariableAsUInt32Array(baseId + 3L);
        this.snmpObjectId = oid != null ? new SnmpObjectId(oid) : null;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariable(baseId, this.name);
        msg.setVariableInt16(baseId + 1L, this.dataType);
        if (this.transformationScript != null && !this.transformationScript.isEmpty()) {
            msg.setVariable(baseId + 2L, this.transformationScript);
        }
        if (this.snmpObjectId != null) {
            this.snmpObjectId.setNXCPVariable(msg, baseId + 3L);
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public SnmpObjectId getSnmpObjectId() {
        return this.snmpObjectId;
    }

    public void setSnmpObjectId(SnmpObjectId snmpObjectId) {
        this.snmpObjectId = snmpObjectId;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public String getName() {
        return this.name;
    }
}

