/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.DciValue;

public class ThresholdViolationSummary {
    private long nodeId;
    private List<DciValue> dciList;

    public ThresholdViolationSummary(NXCPMessage msg, long baseId) {
        this.nodeId = msg.getVariableAsInt64(baseId);
        int count = msg.getVariableAsInteger(baseId + 1L);
        this.dciList = new ArrayList<DciValue>(count);
        long varId = baseId + 2L;
        int i = 0;
        while (i < count) {
            this.dciList.add(DciValue.createFromMessage(this.nodeId, msg, varId));
            varId += 50L;
            ++i;
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public List<DciValue> getDciList() {
        return this.dciList;
    }

    public int getCurrentSeverity() {
        int severity = 0;
        for (DciValue v : this.dciList) {
            if (v.getActiveThreshold().getCurrentSeverity() <= severity) continue;
            severity = v.getActiveThreshold().getCurrentSeverity();
        }
        return severity;
    }
}

