/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class EventInfo {
    private long id;
    private Date timeStamp;
    private long sourceObjectId;
    private int code;
    private String name;
    private int severity;
    private String message;
    private EventInfo parent;
    private List<EventInfo> children;

    public EventInfo(NXCPMessage msg, long baseId, EventInfo parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.children = null;
        this.id = msg.getVariableAsInt64(baseId);
        this.code = msg.getVariableAsInteger(baseId + 2L);
        this.name = msg.getVariableAsString(baseId + 3L);
        this.severity = msg.getVariableAsInteger(baseId + 4L);
        this.sourceObjectId = msg.getVariableAsInt64(baseId + 5L);
        this.timeStamp = msg.getVariableAsDate(baseId + 6L);
        this.message = msg.getVariableAsString(baseId + 7L);
    }

    private void addChild(EventInfo e) {
        if (this.children == null) {
            this.children = new ArrayList<EventInfo>();
        }
        this.children.add(e);
    }

    public long getId() {
        return this.id;
    }

    public EventInfo getParent() {
        return this.parent;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public EventInfo[] getChildren() {
        return this.children != null ? this.children.toArray(new EventInfo[this.children.size()]) : new EventInfo[]{};
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }
}

