/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.topology.Port;

public class VlanInfo {
    private int vlanId;
    private String name;
    private Port[] ports;

    public VlanInfo(NXCPMessage msg, long baseId) {
        this.vlanId = msg.getVariableAsInteger(baseId);
        this.name = msg.getVariableAsString(baseId + 1L);
        int count = msg.getVariableAsInteger(baseId + 2L);
        this.ports = new Port[count];
        long[] sps = msg.getVariableAsUInt32Array(baseId + 3L);
        long[] indexes = msg.getVariableAsUInt32Array(baseId + 4L);
        long[] ids = msg.getVariableAsUInt32Array(baseId + 5L);
        int i = 0;
        while (i < count) {
            this.ports[i] = new Port(ids[i], indexes[i], (int)(sps[i] >> 16), (int)(sps[i] & 0xFFFFL));
            ++i;
        }
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public String getName() {
        return this.name;
    }

    public Port[] getPorts() {
        return this.ports;
    }
}

