/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapObject;

public class NetworkMapElement {
    public static final int MAP_ELEMENT_GENERIC = 0;
    public static final int MAP_ELEMENT_OBJECT = 1;
    public static final int MAP_ELEMENT_DECORATION = 2;
    protected long id;
    protected int type;
    protected int x;
    protected int y;

    public static NetworkMapElement createMapElement(NXCPMessage msg, long baseId) {
        int type = msg.getVariableAsInteger(baseId + 1L);
        switch (type) {
            case 1: {
                return new NetworkMapObject(msg, baseId);
            }
            case 2: {
                return new NetworkMapDecoration(msg, baseId);
            }
        }
        return new NetworkMapElement(msg, baseId);
    }

    protected NetworkMapElement(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.type = msg.getVariableAsInteger(baseId + 1L);
        this.x = msg.getVariableAsInteger(baseId + 2L);
        this.y = msg.getVariableAsInteger(baseId + 3L);
    }

    public NetworkMapElement(long id) {
        this.id = id;
        this.type = 0;
        this.x = 0;
        this.y = 0;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariableInt32(baseId, (int)this.id);
        msg.setVariableInt16(baseId + 1L, this.type);
        msg.setVariableInt32(baseId + 2L, this.x);
        msg.setVariableInt32(baseId + 3L, this.y);
    }

    public int getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public long getId() {
        return this.id;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkMapElement) {
            return ((NetworkMapElement)obj).id == this.id;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (int)this.id;
    }
}

