/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.propertypages;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Report;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ReportDefinition
extends PropertyPage {
    private Report object;
    private Text reportDefinition;
    private boolean modified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Report)this.getElement().getAdapter(Report.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Report definition");
        this.reportDefinition = new Text(dialogArea, 2816);
        this.reportDefinition.setText(this.object.getDefinition());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.reportDefinition.setLayoutData((Object)gd);
        this.reportDefinition.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReportDefinition.this.modified = true;
            }
        });
        Button updateButton = new Button(dialogArea, 8);
        updateButton.setText("Update from file...");
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReportDefinition.this.updateDefinitionFromFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return dialogArea;
    }

    private void updateDefinitionFromFile() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setText("Select File");
        fd.setFilterExtensions(new String[]{"*.jrxml", "*.*"});
        fd.setFilterNames(new String[]{"Jasper Report Files", "All Files"});
        String selected = fd.open();
        if (selected != null) {
            File file = new File(selected);
            byte[] buffer = new byte[(int)file.length()];
            try {
                FileInputStream in = new FileInputStream(file);
                try {
                    in.read(buffer);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                this.reportDefinition.setText(new String(buffer));
                this.modified = true;
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)("Cannot load report definition from file: " + e.getLocalizedMessage()));
            }
        }
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.modified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final String newDefinition = this.reportDefinition.getText();
        new ConsoleJob("Update report definition", null, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ((NXCSession)ConsoleSharedData.getSession()).setReportDefinition(ReportDefinition.this.object.getObjectId(), newDefinition);
            }

            protected String getErrorMessage() {
                return "Cannot update report definition";
            }

            protected void jobFinalize() {
                if (isApply) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportDefinition.this.setValid(true);
                            ReportDefinition.this.modified = false;
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

