/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.Session;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.Activator;
import org.netxms.ui.eclipse.usermanager.UserComparator;
import org.netxms.ui.eclipse.usermanager.UserLabelProvider;
import org.netxms.ui.eclipse.usermanager.dialogs.ChangePasswordDialog;
import org.netxms.ui.eclipse.usermanager.dialogs.CreateObjectDialog;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserManagementView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.usermanager.view.user_manager";
    public static final String JOB_FAMILY = "UserManagerJob";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_FULLNAME = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    public static final int COLUMN_GUID = 4;
    private TableViewer viewer;
    private Session session;
    private UserManager userManager;
    private SessionListener sessionListener;
    private boolean databaseLocked = false;
    private boolean editNewUser = false;
    private Action actionAddUser;
    private Action actionAddGroup;
    private Action actionEditUser;
    private Action actionDeleteUser;
    private Action actionChangePassword;
    private RefreshAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.userManager = (UserManager)ConsoleSharedData.getSession();
        String[] names = new String[]{"Name", "Type", "Full Name", "Description", "GUID"};
        int[] widths = new int[]{100, 80, 180, 250, 250};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new UserLabelProvider());
        this.viewer.setComparator((ViewerComparator)new UserComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    UserManagementView.this.actionEditUser.setEnabled(selection.size() == 1);
                    UserManagementView.this.actionChangePassword.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof User);
                    UserManagementView.this.actionDeleteUser.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                UserManagementView.this.actionEditUser.run();
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 3) {
                    new UIJob(UserManagementView.this.viewer.getControl().getDisplay(), "Update user list"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            UserManagementView.this.viewer.setInput((Object)UserManagementView.this.userManager.getUserDatabaseObjects());
                            if (UserManagementView.this.editNewUser && n.getSubCode() == 0L) {
                                UserManagementView.this.editNewUser = false;
                                UserManagementView.this.viewer.setSelection((ISelection)new StructuredSelection(n.getObject()), true);
                                UserManagementView.this.actionEditUser.run();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        };
        new ConsoleJob("Open user database", (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                UserManagementView.this.userManager.lockUserDatabase();
                UserManagementView.this.databaseLocked = true;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UserManagementView.this.viewer.setInput((Object)UserManagementView.this.userManager.getUserDatabaseObjects());
                        UserManagementView.this.session.addListener(UserManagementView.this.sessionListener);
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        UserManagementView.this.getViewSite().getPage().hideView((IViewPart)UserManagementView.this);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot lock user database";
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddUser);
        manager.add((IAction)this.actionAddGroup);
        manager.add((IAction)this.actionChangePassword);
        manager.add((IAction)this.actionDeleteUser);
        manager.add((IAction)this.actionEditUser);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddUser);
        manager.add((IAction)this.actionAddGroup);
        manager.add((IAction)this.actionDeleteUser);
        manager.add((IAction)this.actionEditUser);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void makeActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                UserManagementView.this.viewer.setInput((Object)UserManagementView.this.userManager.getUserDatabaseObjects());
            }
        };
        this.actionAddUser = new Action(){

            public void run() {
                UserManagementView.this.addUser();
            }
        };
        this.actionAddUser.setText("Create new &user");
        this.actionAddUser.setImageDescriptor(Activator.getImageDescriptor("icons/user_add.png"));
        this.actionAddGroup = new Action(){

            public void run() {
                UserManagementView.this.addGroup();
            }
        };
        this.actionAddGroup.setText("Create new &group");
        this.actionAddGroup.setImageDescriptor(Activator.getImageDescriptor("icons/group_add.png"));
        this.actionEditUser = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.actionEditUser.setText("&Properties");
        this.actionEditUser.setImageDescriptor(Activator.getImageDescriptor("icons/user_edit.png"));
        this.actionEditUser.setEnabled(false);
        this.actionDeleteUser = new Action(){

            public void run() {
                UserManagementView.this.deleteUser();
            }
        };
        this.actionDeleteUser.setText("&Delete");
        this.actionDeleteUser.setImageDescriptor(Activator.getImageDescriptor("icons/user_delete.png"));
        this.actionDeleteUser.setEnabled(false);
        this.actionChangePassword = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)UserManagementView.this.viewer.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof User) {
                    User user = (User)firstElement;
                    ChangePasswordDialog dialog = new ChangePasswordDialog(UserManagementView.this.getSite().getShell(), user.getId() == (long)UserManagementView.this.session.getUserId());
                    if (dialog.open() == 0) {
                        try {
                            UserManagementView.this.userManager.setUserPassword(user.getId(), dialog.getPassword(), dialog.getOldPassword());
                        }
                        catch (Exception e) {
                            MessageDialogHelper.openError((Shell)UserManagementView.this.getSite().getShell(), (String)"Unable to change password", (String)e.getMessage());
                        }
                    }
                }
            }
        };
        this.actionChangePassword.setText("Change Password");
        this.actionChangePassword.setImageDescriptor(Activator.getImageDescriptor("icons/change_password.png"));
        this.actionChangePassword.setEnabled(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                UserManagementView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAddUser);
        mgr.add((IAction)this.actionAddGroup);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof User) {
            mgr.add((IAction)this.actionChangePassword);
        }
        mgr.add((IAction)this.actionDeleteUser);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionEditUser);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.databaseLocked) {
            new ConsoleJob("Unlock user database", null, "org.netxms.ui.eclipse.usermanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    UserManagementView.this.userManager.unlockUserDatabase();
                }

                protected String getErrorMessage() {
                    return "Cannot unlock user database";
                }
            }.start();
        }
        super.dispose();
    }

    private void addUser() {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.getViewSite().getShell(), true);
        if (dlg.open() == 0) {
            new ConsoleJob("Create user", (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", JOB_FAMILY){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    UserManagementView.this.editNewUser = dlg.isEditAfterCreate();
                    UserManagementView.this.userManager.createUser(dlg.getLoginName());
                }

                protected String getErrorMessage() {
                    return "Cannot create user";
                }
            }.start();
        }
    }

    private void addGroup() {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.getViewSite().getShell(), false);
        if (dlg.open() == 0) {
            new ConsoleJob("Create group", (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", JOB_FAMILY){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    UserManagementView.this.editNewUser = dlg.isEditAfterCreate();
                    UserManagementView.this.userManager.createUserGroup(dlg.getLoginName());
                }

                protected String getErrorMessage() {
                    return "Cannot create group";
                }
            }.start();
        }
    }

    private void deleteUser() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        String message = "Do you really wish to delete selected user" + (selection.size() > 1 ? "s?" : "?");
        Shell shell = this.getViewSite().getShell();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)"Confirm user deletion", (String)message)) {
            return;
        }
        new ConsoleJob("Delete user database objects", (IWorkbenchPart)this, "org.netxms.ui.eclipse.usermanager", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object object : selection.toList()) {
                    UserManagementView.this.userManager.deleteUserDBObject(((AbstractUserObject)object).getId());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete user database object";
            }
        }.start();
    }
}

