/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.CommandBox;

public class Commands
extends OverviewPageElement {
    private CommandBox commandBox;
    private Action actionRestartAgent;
    private Action actionRestart;
    private Action actionShutdown;
    private Action actionWakeup;

    public Commands(Composite parent, GenericObject object) {
        super(parent, object);
        this.createActions();
    }

    private void createActions() {
        this.actionWakeup = new Action("Wakeup node using Wake-on-LAN"){

            public void run() {
                final GenericObject object = Commands.this.getObject();
                new ConsoleJob("Wakeup node", null, "org.netxms.ui.eclipse.objectview", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                        session.wakeupNode(object.getObjectId());
                    }

                    protected String getErrorMessage() {
                        return "Cannot send wake-on-LAN packet to node";
                    }
                }.start();
            }
        };
        this.actionWakeup.setImageDescriptor(Activator.getImageDescriptor("icons/wol.png"));
        this.actionRestartAgent = new Action("Restart NetXMS agent"){

            public void run() {
                final GenericObject object = Commands.this.getObject();
                if (MessageDialogHelper.openQuestion((Shell)Commands.this.getShell(), (String)"Confirmation", (String)("Node " + object.getObjectName() + " will be rebooted. Are you sure?"))) {
                    new ConsoleJob("Initiate agent restart on node " + object.getObjectName(), null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                            session.executeAction(object.getObjectId(), "Agent.Restart");
                        }

                        protected String getErrorMessage() {
                            return "Cannot initiate agent restart on node " + object.getObjectName();
                        }
                    }.start();
                }
            }
        };
        this.actionRestartAgent.setImageDescriptor(Activator.getImageDescriptor("icons/restart.png"));
        this.actionRestart = new Action("Restart system"){

            public void run() {
                final GenericObject object = Commands.this.getObject();
                if (MessageDialogHelper.openQuestion((Shell)Commands.this.getShell(), (String)"Confirmation", (String)("Node " + object.getObjectName() + " will be rebooted. Are you sure?"))) {
                    new ConsoleJob("Initiate node restart", null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                            session.executeAction(object.getObjectId(), "System.Restart");
                        }

                        protected String getErrorMessage() {
                            return "Cannot initiate node restart";
                        }
                    }.start();
                }
            }
        };
        this.actionRestart.setImageDescriptor(Activator.getImageDescriptor("icons/restart.png"));
        this.actionShutdown = new Action("Shutdown system"){

            public void run() {
                final GenericObject object = Commands.this.getObject();
                if (MessageDialogHelper.openQuestion((Shell)Commands.this.getShell(), (String)"Confirmation", (String)("Node " + object.getObjectName() + " will be shut down. Are you sure?"))) {
                    new ConsoleJob("Initiate node shutdown", null, "org.netxms.ui.eclipse.objectview", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                            session.executeAction(object.getObjectId(), "System.Shutdown");
                        }

                        protected String getErrorMessage() {
                            return "Cannot initiate node shutdown";
                        }
                    }.start();
                }
            }
        };
        this.actionShutdown.setImageDescriptor(Activator.getImageDescriptor("icons/shutdown.png"));
    }

    @Override
    protected String getTitle() {
        return "Commands";
    }

    @Override
    void onObjectChange() {
        this.commandBox.deleteAll(false);
        if (this.getObject() instanceof Node) {
            this.commandBox.add(this.actionWakeup, false);
            if (((Node)this.getObject()).hasAgent()) {
                this.commandBox.add(this.actionRestart, false);
                this.commandBox.add(this.actionShutdown, false);
            }
        } else if (this.getObject() instanceof Interface) {
            this.commandBox.add(this.actionWakeup, false);
        }
        this.commandBox.rebuild();
    }

    protected Control createClientArea(Composite parent) {
        this.commandBox = new CommandBox(parent, 0);
        return this.commandBox;
    }

    @Override
    public boolean isApplicableForObject(GenericObject object) {
        return object instanceof Node || object instanceof Interface;
    }
}

