/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.CreateMobileDeviceDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateMobileDevice
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final CreateMobileDeviceDialog dlg = new CreateMobileDeviceDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Create new mobile device", this.part, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCObjectCreationData cd = new NXCObjectCreationData(31, dlg.getName(), CreateMobileDevice.this.parentId);
                cd.setDeviceId(dlg.getDeviceId());
                session.createObject(cd);
            }

            protected String getErrorMessage() {
                return "Cannot create mobile device object \"" + dlg.getName() + "\"";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof Container || object instanceof ServiceRoot ? ((GenericObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }
}

