/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class MultipleObjectAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchWindow window;
    private IWorkbenchPart part;

    protected abstract String jobDescription();

    protected abstract String errorPrefix();

    protected abstract void runObjectAction(NXCSession var1, GenericObject var2) throws Exception;

    protected boolean confirm() {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
        this.part = targetPart;
    }

    public final void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        if (!this.confirm()) {
            return;
        }
        for (final GenericObject object : this.selection) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob(String.valueOf(this.jobDescription()) + " " + object.getObjectName() + " [" + object.getObjectId() + "]", this.part, "org.netxms.ui.eclipse.objectmanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    MultipleObjectAction.this.runObjectAction(session, object);
                }

                protected String getErrorMessage() {
                    return String.valueOf(MultipleObjectAction.this.errorPrefix()) + " " + object.getObjectName();
                }
            }.start();
        }
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(this.selection.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }

    protected IStructuredSelection getSelection() {
        return this.selection;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }
}

