/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class NetworkServicePolling
extends PropertyPage {
    private NetworkService object;
    private Combo serviceType;
    private LabeledText port;
    private LabeledText request;
    private LabeledText response;
    private ObjectSelector pollerNode;
    private Spinner pollCount;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (NetworkService)this.getElement().getAdapter(NetworkService.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.serviceType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Service type", (Object)gd);
        this.serviceType.add("User-defined");
        this.serviceType.add("SSH");
        this.serviceType.add("POP3");
        this.serviceType.add("SMTP");
        this.serviceType.add("FTP");
        this.serviceType.add("HTTP");
        this.serviceType.add("Telnet");
        this.serviceType.select(this.object.getServiceType());
        this.port = new LabeledText(dialogArea, 0);
        this.port.setLabel("Port");
        this.port.setText(Integer.toString(this.object.getPort()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.port.setLayoutData((Object)gd);
        this.request = new LabeledText(dialogArea, 0);
        this.request.setLabel("Request");
        this.request.setText(this.object.getRequest());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.request.setLayoutData((Object)gd);
        this.response = new LabeledText(dialogArea, 0);
        this.response.setLabel("Response");
        this.response.setText(this.object.getResponse());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.response.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector(dialogArea, 0, true);
        this.pollerNode.setLabel("Poller node");
        this.pollerNode.setEmptySelectionName("<default>");
        this.pollerNode.setObjectClass(Node.class);
        this.pollerNode.setObjectId(this.object.getPollerNode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"Required poll count", (int)0, (int)1000, (Object)gd);
        this.pollCount.setSelection(this.object.getPollCount());
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        try {
            int ipPort = Integer.parseInt(this.port.getText());
            if (ipPort < 1 || ipPort > 65535) {
                throw new NumberFormatException();
            }
            md.setIpPort(ipPort);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter valid port number (1 .. 65535)");
            return false;
        }
        md.setRequiredPolls(this.pollCount.getSelection());
        md.setServiceType(this.serviceType.getSelectionIndex());
        md.setRequest(this.request.getText());
        md.setResponse(this.response.getText());
        md.setPollerNode(this.pollerNode.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update network service object", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot update network service object";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            NetworkServicePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

