/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.console.api.BrandingProvider;

public class BrandingManager {
    private static BrandingManager instance = null;
    private Map<Integer, BrandingProvider> providers = new TreeMap<Integer, BrandingProvider>();

    public static BrandingManager getInstance() {
        return instance;
    }

    protected static void create() {
        if (instance == null) {
            instance = new BrandingManager();
        }
    }

    private BrandingManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.branding");
        int i = 0;
        while (i < elements.length) {
            try {
                BrandingProvider p = (BrandingProvider)elements[i].createExecutableExtension("class");
                int priority = 65535;
                String value = elements[i].getAttribute("priority");
                if (value != null) {
                    try {
                        priority = Integer.parseInt(value);
                        if (priority < 0) {
                            priority = 65535;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.providers.put(priority, p);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public String getDefaultPerspective() {
        for (BrandingProvider p : this.providers.values()) {
            String pid = p.getDefaultPerspective();
            if (pid == null) continue;
            return pid;
        }
        return null;
    }

    public ImageDescriptor getLoginTitleImage() {
        for (BrandingProvider p : this.providers.values()) {
            ImageDescriptor d = p.getLoginTitleImage();
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public RGB getLoginTitleColor() {
        for (BrandingProvider p : this.providers.values()) {
            RGB rgb = p.getLoginTitleColor();
            if (rgb == null) continue;
            return rgb;
        }
        return null;
    }

    public String getLoginTitle() {
        for (BrandingProvider p : this.providers.values()) {
            String t = p.getLoginTitle();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public String getRedirectionURL() {
        for (BrandingProvider p : this.providers.values()) {
            String t = p.getRedirectionURL();
            if (t == null) continue;
            return t;
        }
        return "nxmc";
    }
}

