/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.compress;

import java.util.ArrayList;
import org.swtchart.internal.compress.CompressConfig;
import org.swtchart.internal.compress.ICompress;

public abstract class Compress
implements ICompress {
    protected int previousXGridIndex;
    protected int previousYGridIndex;
    protected CompressConfig config;
    protected CompressConfig prevConfig;
    protected boolean compressed;
    protected double[] xSeries = null;
    protected double[] ySeries = null;
    protected transient double[] compressedXSeries = null;
    protected transient double[] compressedYSeries = null;
    protected transient int[] compressedIndexes = null;
    protected double xLower;
    protected double xUpper;
    protected double yLower;
    protected double yUpper;
    private boolean isXLogScale;
    private boolean isYLogScale;
    private long widthInPixel;
    private long heightInPixel;

    @Override
    public void setXSeries(double[] xSeries) {
        if (xSeries == null) {
            return;
        }
        double[] copiedSeries = new double[xSeries.length];
        System.arraycopy(xSeries, 0, copiedSeries, 0, xSeries.length);
        this.xSeries = copiedSeries;
        this.compressedXSeries = copiedSeries;
        this.compressedIndexes = new int[xSeries.length];
        int i = 0;
        while (i < xSeries.length) {
            this.compressedIndexes[i] = i;
            ++i;
        }
        this.compressed = false;
    }

    @Override
    public void setYSeries(double[] ySeries) {
        if (ySeries == null) {
            return;
        }
        double[] copiedSeries = new double[ySeries.length];
        System.arraycopy(ySeries, 0, copiedSeries, 0, ySeries.length);
        this.ySeries = copiedSeries;
        this.compressedYSeries = copiedSeries;
        this.compressed = false;
    }

    @Override
    public double[] getCompressedXSeries() {
        double[] copiedSeries = new double[this.compressedXSeries.length];
        System.arraycopy(this.compressedXSeries, 0, copiedSeries, 0, this.compressedXSeries.length);
        return copiedSeries;
    }

    @Override
    public double[] getCompressedYSeries() {
        double[] copiedSeries = new double[this.compressedYSeries.length];
        System.arraycopy(this.compressedYSeries, 0, copiedSeries, 0, this.compressedYSeries.length);
        return copiedSeries;
    }

    @Override
    public int[] getCompressedIndexes() {
        int[] copiedSeries = new int[this.compressedIndexes.length];
        System.arraycopy(this.compressedIndexes, 0, copiedSeries, 0, this.compressedIndexes.length);
        return copiedSeries;
    }

    @Override
    public final boolean compress(CompressConfig compressConfig) {
        if (compressConfig.equals(this.prevConfig) && this.compressed || this.xSeries == null || this.ySeries == null) {
            return false;
        }
        this.prevConfig = new CompressConfig(compressConfig);
        this.config = compressConfig;
        this.xLower = this.config.getXLowerValue();
        this.xUpper = this.config.getXUpperValue();
        this.yLower = this.config.getYLowerValue();
        this.yUpper = this.config.getYUpperValue();
        this.isXLogScale = this.config.isXLogScale();
        this.isYLogScale = this.config.isYLogScale();
        this.widthInPixel = this.config.getWidthInPixel();
        this.heightInPixel = this.config.getHeightInPixel();
        this.previousXGridIndex = -1;
        this.previousYGridIndex = -1;
        ArrayList<Double> xList = new ArrayList<Double>();
        ArrayList<Double> yList = new ArrayList<Double>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        this.addNecessaryPlots(xList, yList, indexList);
        this.compressedXSeries = new double[xList.size()];
        this.compressedYSeries = new double[yList.size()];
        this.compressedIndexes = new int[indexList.size()];
        int i = 0;
        while (i < xList.size()) {
            this.compressedXSeries[i] = xList.get(i);
            this.compressedYSeries[i] = yList.get(i);
            this.compressedIndexes[i] = indexList.get(i);
            ++i;
        }
        this.compressed = true;
        return true;
    }

    protected abstract void addNecessaryPlots(ArrayList<Double> var1, ArrayList<Double> var2, ArrayList<Integer> var3);

    protected void addToList(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList, double x, double y, int index) {
        xList.add(x);
        yList.add(y);
        indexList.add(index);
    }

    protected boolean isInSameGridAsPrevious(double x, double y) {
        int yGridIndex;
        int xGridIndex;
        double upper;
        double lower;
        if (this.isXLogScale) {
            lower = Math.log10(this.xLower);
            upper = Math.log10(this.xUpper);
            xGridIndex = (int)((Math.log10(x) - lower) / (upper - lower) * (double)this.widthInPixel);
        } else {
            xGridIndex = (int)((x - this.xLower) / (this.xUpper - this.xLower) * (double)this.widthInPixel);
        }
        if (this.isYLogScale) {
            lower = Math.log10(this.yLower);
            upper = Math.log10(this.yUpper);
            yGridIndex = (int)((Math.log10(y) - lower) / (upper - lower) * (double)this.heightInPixel);
        } else {
            yGridIndex = (int)((y - this.yLower) / (this.yUpper - this.yLower) * (double)this.heightInPixel);
        }
        boolean isInSameGridAsPrevious = xGridIndex == this.previousXGridIndex && yGridIndex == this.previousYGridIndex;
        this.previousXGridIndex = xGridIndex;
        this.previousYGridIndex = yGridIndex;
        return isInSameGridAsPrevious;
    }
}

